---
title: Basic Math
localeTitle: Базовая математика
---
# Математика в C

C предоставляет множество возможностей для математики. Сначала мы начнем с некоторых из наиболее распространенных.

## Основной материал

Эти следующие примеры не являются полным кодом, они просто примеры того, как выглядит часть кода. Помните, что в C нам нужно, чтобы все было объявлено до того, как мы его используем, `result` : `a` и `b` должны быть уже инициализированы и установлены в значение. Являются ли они `int` , `double` или что-то важное для предотвращения ошибок и потери информации - мы доберемся до этого позже.

#### Дополнение: `+`

Дополнение выполняется с помощью `+` , например:

```C
result = a + b; 
```

В приведенном выше примере переменный `result` будет равен a + b.

#### Вычитание: `-`

Дополнение выполняется с помощью: `-` , так:

```C
result = a - b; 
```

В приведенном выше примере переменный `result` будет равен a - b.

#### Умножение: `*`

Умножение выполняется с помощью `*` , например:

```C
result = a * b; 
```

В приведенном выше примере переменный `result` будет равен умножению на b.

#### Отдел: `/`

Разделение выполняется с помощью `/` , например:

```C
result = a / b; 
```

В приведенном выше примере переменный `result` будет равен делению на b. Тем не менее, это не всегда доля от более b. Когда дело касается целых чисел, все становится немного по-другому - об этом позже.

# Не совсем базовый материал

## Modulo: '%'

Хорошо, теперь все начинает немного странно.

Modulo позволяет вам найти остаток в разделе. Помните, что с целыми числами мы не можем иметь десятичное число. Отдел рассказывает о том, сколько раз один номер будет вписываться в другой, modulo - это поиск того, что осталось. Возьмите 27, разделенных на 4: 4, в 27 раз. 6 раз 4 равно 24, что означает, что осталось 3. В результате 27% 4 равно 3. 10, разделенное на 5, равно 2, 2 раза 5 равно 10, поэтому осталось 0. В результате 10% 5 равно 0.

Оператор modulo более важен, чем вы думаете, особенно в C, где соблюдается разница между числами с плавающей точкой и целыми числами. Это удобно. Вот пример:

```C
result = a % b; 
```

В приведенном выше примере `result` будет равен модулю b.

## Целые числа и математика

Целые числа не могут иметь десятичные числа. В результате, когда вы выполняете деление с целыми числами, любое десятичное число будет усечено. Например, 17, деленный на 10, равен 1,7. Однако, если мы имеем дело только с целыми числами, этот результат будет равен 1, а не 1.7. 10 помещается в 17 1 раз, поэтому ответ 1.

При работе с числами с плавающей запятой это не проблема. Числа с плавающей запятой могут принимать десятичные разряды, поэтому нам не нужно беспокоиться о том, что вещи усекаются.

### Почему C это делает?

C, как обсуждалось ранее, является языком низкого уровня. Существуют большие различия между числами с плавающей запятой и целыми числами в аппаратных средствах компьютера, и они требуют, чтобы определенные типы данных имели определенные свойства (например, не принимать десятичные числа, например). C не делает никаких предположений относительно того, что вы хотите, и заставляет вас думать об этом самостоятельно.

### Почему бы нам просто не использовать числа с плавающей точкой все время?

Это также сводится к тому, что C является языком низкого уровня. C намного, намного быстрее и намного, намного легче, чем многие другие языки, и одна из причин, по которой это происходит, из-за того, что программист может принимать интеллектуальные решения о типах данных. Помните, что числа с плавающей запятой занимают гораздо больше памяти, чем целые. В результате важно использовать соответствующий тип данных и обрабатывать целые числа с конверсиями с плавающей запятой, когда это необходимо.

### Как нам обойти это?

Кастинг (описанный ниже) является одним из решений. Другой использует числа с плавающей запятой. Если один или оба числа, которыми управляют, являются числом с плавающей запятой, результатом будет число с плавающей запятой. Это становится более сложным, когда мы начинаем разбираться с порядком операций, но на данный момент помните, что это работает:

```C
double result = 23.0 / 2; 
```

# Полный пример

```C
#include <stdio.h> 
 
 // This is a comment. It gets ignored by the compiler, so we can write notes after the double slashes. 
 
 int main(void) { 
    int a = 3; 
    int b = 5; 
    int result = 0; 
 
    // Doing things with variables: 
    result = a + b; 
    printf("a plus b = %i \n", result); 
 
    // You can also do the operation inside the printf. 
    // Here's an example of that with subtraction: 
    printf("a minus b = %i \n", ab); 
 
    // You don't need to do this with variables at all. 
    // Here's an example of that with multiplication: 
    printf("10 times 5 = %i \n", 10*5); 
 
    // Here's a look at division. 
    // Notice that the decimals are truncated because we're dealing with integers. 
    printf("12 divided by 5 = %i \n", 12/5); 
 
    // Now let's force floating point numbers by including a decimal. 
    // Notice that even though these are integers, the decimal forces them to be 
    // treated as floating point numbers, so they aren't truncated. 
    // Note that I'm printing a double with %d, not an int with %i. 
    printf("12.0 divided by 5 = %d \n", 12.0/5); 
 
    return 0; 
 } 
```

Дайте этому пробегу посмотреть, что происходит, и обязательно играйте с операторами и ценностями, чтобы узнать, что и как все меняется.

# Математическая библиотека

C предоставляет математическую библиотеку ( `math.h` ), которая предоставляет множество полезных математических функций. Например, мощность числа может быть рассчитана как:

```#include<math.h>
int result = pow(2,3) // will result in 2*2*2 or 8 
```

Некоторые другие ( `math.h` ) библиотечные функции, которые могут оказаться полезными:

`#include <math.h> double angle = cos(90.00); // Givs us 0.00 int result = sqrt(16); // Gives us 4 double result = log(10.00) // Gives us 2.30 (note this is ln(10), not log base 10)`

// C-код для иллюстрации // использование функции ceil.

# включают

# включают

int main () { float val1, val2, val3, val4;

val1 = 1,6; val2 = 1,2; val3 = -2,8; val4 = -2,3;

printf ("value1 =% .1lf \\ n", ceil (val1)); printf ("value2 =% .1lf \\ n", ceil (val2)); printf ("value3 =% .1lf \\ n", ceil (val3)); printf ("value4 =% .1lf \\ n", ceil (val4));

Возвращение (0); }

# Прежде чем продолжить ...

## Обзор

*   Существует несколько основных операторов:
*   `+` для добавления
*   `-` для вычитания
*   `*` для умножения
*   `/` для деления
*   `%` по модулю
*   Кроме того, есть еще несколько операторов, но мы подробно рассмотрим их позже.
*   Целочисленная математика - это вещь, о которой довольно сложно.
*   C очень строг относительно типов данных
*   Если задействованы только целые числа, возвращается целое число
*   Если в операции задействован номер с плавающей запятой, эта часть операции становится плавающей точкой
*   C предоставляет библиотеку `math.h` с несколькими функциями, такими как `pow` для вычисления мощности числа.