---
title: Structured data types
localeTitle: Структурированные типы данных
---
# Структурированные типы данных в C

Во время вашего программирования вы можете почувствовать необходимость определять свой собственный тип данных. В C это выполняется с использованием двух ключевых слов: `struct` и `typedef` . Структуры и союзы предоставят вам возможность хранить неоднородные типы данных в одну коллекцию.

## Объявление нового типа данных

```C
typedef struct student_structure{ 
    char* name; 
    char* surname; 
    int year_of_birth; 
 }student; 
```

После этого маленького `student` кода будет новое зарезервированное ключевое слово, и вы сможете создавать переменные типа `student` . Имейте в виду, что этот новый тип переменной будет структурирован, что означает, что он определяет физически сгруппированный список переменных, которые должны быть помещены под одним именем в блоке памяти.

## Использование нового типа данных

Давайте теперь создадим новую переменную `student` и инициализируем ее атрибуты:

```C
   student stu; 
 
   strcpy( stu.name, "John"); 
   strcpy( stu.surname, "Snow"); 
   stu.year_of_birth = 1990; 
 
   printf( "Student name : %s\n", stu.name); 
   printf( "Student surname : %s\n", stu.surname); 
   printf( "Student year of birth : %d\n", stu.year_of_birth); 
```

Как вы можете видеть в этом примере, вам необходимо присвоить значение всем переменным, содержащимся в вашем новом типе данных. Чтобы получить доступ к структурной переменной, вы можете использовать точку, как в `stu.name` . Существует также более короткий способ присвоения значений структуре:

```C
typedef struct{ 
   int    x; 
   int    y; 
 }point; 
 
 point image_dimension = {640,480}; 
```

Или, если вы предпочитаете устанавливать его значения в соответствии с другим порядком:

```C
point img_dim = { .y = 480, .x = 640 }; 
```

## Союзы против структур

Союзы объявляются в том же виде, что и структуры, но отличаются друг от друга, потому что в любой момент можно использовать только один элемент в союзе.

```C
typedef union{ 
      int circle; 
      int triangle; 
      int ovel; 
 }shape; 
```

Вы должны использовать `union` в таком случае, когда будет применяться только одно условие, и будет использоваться только одна переменная. Не забывайте, что мы также можем использовать наш новый тип данных:

```C
typedef struct{ 
      char* model; 
      int year; 
 }car_type; 
 
 typedef struct{ 
      char* owner; 
      int weight; 
 }truck_type; 
 
 typedef union{ 
  car_type car; 
  truck_type truck; 
 }vehicle; 
```

## Еще несколько трюков

*   Когда вы создаете указатель на структуру с помощью оператора `&` вы можете использовать специальный `->` инфиксный оператор, чтобы почтить его. Это очень полезно, например, при работе со связанными списками в C
*   Новый определенный тип может использоваться так же, как и другие базовые типы для почти всего. Попробуйте, например, создать массив типа `student` и посмотреть, как он работает.
*   Структуры могут быть скопированы или назначены, но вы не можете их сравнить!