---
title: Switch Case
localeTitle: Корпус выключателя
---
# Корпус выключателя

Оператор switch похож на набор `if statements` .

Это список возможностей с действием для каждой возможности и необязательным действием по умолчанию, если ничто иное не оценивает значение true.

Мы выходим из коммутатора на `break` . Если оператор `break` не будет достигнут до начала следующего случая, выполнение провалится и начнет выполнение кода в следующем случае.

## Синтаксис переключателя ... case

```c
switch (n) 
 { 
    case constant1: 
        // code to be executed if n is equal to constant1; 
        break; 
 
    case constant2: 
        // code to be executed if n is equal to constant2; 
        break; 
        . 
        . 
        . 
    default: 
        // code to be executed if n doesn't match any constant 
 } 
```

## пример

Использование оператора switch над несколькими операторами if / else может способствовать большей скорости и удобочитаемости.

```c
# include <stdio.h> 
 
 int main() { 
 
    char operator; 
    double firstNumber,secondNumber; 
 
    printf("Enter an operator (+, -, *, /): "); 
    scanf("%c", &operator); 
 
    printf("Enter two operands: "); 
    scanf("%lf %lf",&firstNumber, &secondNumber); 
 
    switch (operator) { 
        case '+': 
            printf("%.1lf + %.1lf = %.1lf",firstNumber, secondNumber, firstNumber+secondNumber); 
            break; 
        case '-': 
            printf("%.1lf - %.1lf = %.1lf",firstNumber, secondNumber, firstNumber-secondNumber); 
            break; 
        case '*': 
            printf("%.1lf * %.1lf = %.1lf",firstNumber, secondNumber, firstNumber*secondNumber); 
            break; 
        case '/': 
            printf("%.1lf / %.1lf = %.1lf",firstNumber, secondNumber, firstNumber/firstNumber); 
            break; 
        // Operator is doesn't match any case constant (+, -, *, /) 
        default: 
            printf("Error! operator is not correct"); 
    } 
 
    return 0; 
 } 
```

## Вывод:

```c
-> Enter an operator (+, -, *,): - 
 -> Enter two operands: 32.5 
 -> 12.4 
 -> 32.5 - 12.4 = 20.1 
```

## Обзор: Switch vs if else

*   Проверьте выражение тестирования: оператор if-then-else может тестировать выражения на основе диапазонов значений или условий, тогда как оператор switch проверяет выражения, основанные только на одном целочисленном, перечисляемом значении или объекте String.
*   Лучше переключайтесь на многопоточность: когда компилятор компилирует оператор switch, он проверяет каждую из констант case и создает «таблицу перехода», которую он будет использовать для выбора пути выполнения в зависимости от значения выражения. Поэтому, если нам нужно выбрать среди большой группы значений, оператор switch будет работать намного быстрее, чем эквивалентная логическая кодировка с использованием последовательности if-elses. Компилятор может это сделать, потому что он знает, что константы case имеют одинаковый тип и просто должны сравниваться для равенства с выражением switch, тогда как в случае выражений компилятор не имеет таких знаний.
*   if-else лучше для логических значений: If-else условные ветви отлично подходят для переменных условий, которые приводят к булевому, тогда как операторы switch отлично подходят для фиксированных значений данных.
*   Скорость. Оператор switch может оказаться быстрее, чем если бы при условии, что количество дел является хорошим. Если есть только несколько случаев, это может не повлиять на скорость в любом случае. Переключатель предпочтений, если число случаев больше, чем 5, иначе вы можете использовать if-else.
*   Если коммутатор содержит более пяти элементов, он реализуется с помощью таблицы поиска или хеш-листа. Это означает, что все элементы получают одинаковое время доступа по сравнению со списком if: s, где последний элемент занимает гораздо больше времени для достижения, поскольку он должен сначала оценивать каждое предыдущее условие.
*   Ясность в удобочитаемости: коммутатор выглядит намного чище, когда вам приходится комбинировать случаи. Ifs также очень уязвимы для ошибок. Отсутствие заявления другого может нанести вам ущерб. Добавление и удаление меток также проще с помощью переключателя и делает ваш код значительно легче изменять и поддерживать.