---
title: Variables in C
localeTitle: Переменные в C
---
# Использование переменных в C

Теперь вы знаете, какие у вас варианты с типами данных. Давайте применим это с простым примером здесь:

```C
#include <stdio.h> 
 
 int main(void) { 
    int my_first_variable = 12; 
    double my_second_variable = 983.9; 
 
    printf("My int is %i\n", my_first_variable); 
    printf("My double is %f\n", my_second_variable); 
 
    return 0; 
 } 
```

Здесь есть много нового, что можно посмотреть здесь! Вы уже видели `#include` и `int main(void)` , так что не стоит останавливаться на них. Что нового: `int my_first_variable = 12;` ,

С самого начала вы должны помнить, что `int` позволяет хранить целочисленные значения. После слова `int` приходит `my_first_variable` . Это переменная - она ​​может хранить значения, и вы можете изменить, какие значения хранятся в ней. Начнем с объявления, где мы говорим компьютеру, что начальное значение этой переменной равно 12. Важно сообщить компьютеру, что мы хотим, чтобы переменная существовала до того, как мы попытаемся ее использовать. В противном случае переменная не будет существовать, и компилятор не будет знать, что делать, когда вы пытаетесь сказать ей использовать переменную, которая не существует.

Следующая строка - `double my_second_variable = 983.9` . В подобной структуре из ранее должно быть ясно, что вы говорите компьютеру о создании переменной, называемой «моя _вторая_ переменная», которая может содержать `double` значения и что вы хотите установить ее на 983.9.

Фактическое имя переменной не важно. Это может быть то, что вы хотите, если это не слова, которые C зарезервировал для реального языка, и он может включать только числа и буквы, никогда не пробелы. Имя переменной не может начинаться с числа. По соглашению, C использует чистые имена переменных, которые заменяют символы подчеркивания для пробелов. Переменной может быть также camelCase, например:

```C
double myFirstVariable = 983.9 
```

Фактически, это было бы так на других языках. Однако в C это обычно не делается.

После того, как переменные создаются, мы фактически начнем их использовать:

```C
    printf("My int is %i\n", my_first_variable); 
    printf("My double is %f\n", my_second_variable); 
```

Это тот же самый printf (), который вы использовали ранее, но теперь он имеет несколько разных функций. Во-первых, обратите внимание, что в круглой скобке есть две вещи: текст для печати на экране и переменная. Также обратите внимание на `%i` и `%f` . Это называется _спецификатором формата_ и используется для указания формата, в котором что-то должно быть напечатано. Всякий раз, когда printf () встречается с одним из них, он попытается вставить указанную переменную в эту точку.

Поскольку типы данных наших переменных представлены на компьютере несколькими различными способами, для отображения их можно указать несколько разных способов:

Тип данных | Спецификатор формата ---------------- | ------------------ char | % c, или% hhi для печати в виде числа при подписании,% hhu для печати в виде числа, когда unsigned короткие | % hi, или% hu, когда unsigned int | % i,% d также можно использовать долго | % li, или% lu, когда unsigned длинный длинный | % lli, или% llu, когда unsigned поплавок | % е двойной | % е длинный двойной | % Lf unsigned int | % лу

Чтобы напечатать переменную, у вас должен быть спецификатор формата, а затем переменная для форматирования. Несколько спецификаторов формата могут быть вместе в одном и том же printf ():

```C
    printf("%i and %f", my_first_variable, my_second_variable); 
```

Чтобы сканировать переменную, у вас должен быть спецификатор формата, а затем адрес переменной (обозначается добавлением «&» перед именем переменной) для ввода. Несколько спецификаторов формата могут быть вместе в одном и том же scanf ():

```C
    scanf("%i and %f", &my_first_variable, &my_second_variable); 
```

Теперь давайте начнем изменять значения внутри наших переменных. Вот те же примеры из предыдущих, но с несколькими строками:

```C
#include <stdio.h> 
 
 int main(void) { 
    int my_first_variable = 12; 
    double my_second_variable = 983.9; 
 
    printf("My int is %i\n", my_first_variable); 
    printf("My double is %f\n", my_second_variable); 
 
    my_second_variable = -18.2 + my_first_variable; 
 
    printf("Now my double is %f\n", my_second_variable); 
 
    return 0; 
 } 
```

Теперь есть строка, которая читает `my_second_variable = -18.2 + my_first_variable;` , Это уравнение присваивает новое значение переменной слева. Всякий раз, когда назначается новое значение, переменная, которую он назначает, всегда должна быть слева и всегда должна быть там одна. Ваша программа найдет результат правой стороны и назначит ее переменной слева. В этом случае мы добавили мою _первую_ переменную в -18.2. моя _первая_ переменная равна 12, а -18.2 + 12 - -6.2, поэтому моя _вторая_ переменная становится -6.2 после этого шага. Мы немного поработаем в математике!

## Немного больше о поплавках и парных

При печати поплавков и удвоений много раз нам нужна точность после десятичной точки. Если у нас есть

```C
float var1 = 15.3; 
 printf("%f"); 
```

Мы получаем `15.300000` . Итак, скажем, мы просто хотим, чтобы два места после десятичной даты дали нам `15.30` . Мы использовали бы% .2f. Обратите внимание: мы используем десятичную точку перед количеством десятичных знаков, за которым следует f, и мы хотим напечатать float или double.

# Имена переменных

*   Единственными символами, которые вы можете использовать в именах, являются алфавитные символы, числовые цифры и символ подчеркивания (\_).
*   Первый символ в имени не может быть числовой цифрой.
*   Верхние символы считаются отличными от символов нижнего регистра.
*   Вы не можете использовать ключевое слово C для имени.

# Прежде чем продолжить ...

## Обзор

*   Переменные должны быть созданы до их использования.
*   Переменные создаются в следующем формате: `datatype variable_name = number` .
*   Спецификаторы формата позволяют печатать переменные.
*   Знак равенства `=` позволяет присваивать значения переменным.