---
title: Basic Usage
localeTitle: Основное использование
---
## Основное использование холста

При использовании холста сначала помещайте холст в документ как элемент.

```html

<canvas width="400" height="400" id="canvas"></canvas> 
```

Атрибуты `width` и `height` будут определять размер холста. Эти атрибуты управляют размером холста чертежа, а не фактическим отображаемым размером. Дополнительную информацию см. На странице «Размеры холста».

Чтобы использовать `canvas` , мы должны сначала захватить элемент со страницы как элемент DOM, а затем получить от него контекст рисования.

```js
var canvas = document.getElementById("canvas"); 
 var ctx = canvas.getContext('2d'); 
```

Все вызовы рисования после этого будут сделаны из объекта `ctx` . `ctx` представляет контекст чертежа объекта и содержит информацию о двумерном пространстве рисования. Объект `canvas` является фактическим элементом DOM. Взаимодействие с ним позволяет нам получить доступ к таким атрибутам, как `width` и `height` .

Существует несколько доступных контекстов рисования, включая `webgl` . WebGL - это совершенно другая технология, поэтому мы будем фокусироваться только на 2D-чертеже.

Пути - это строительный блок рисования в `canvas` . Дополнительную информацию см. На странице « [Пути](/articles/canvas/paths) ».

#### Дополнительная информация:

*   [API холста MDN](https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API)
*   [HTMLCanvasElement.getContext () (MDN)](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/getContext)