---
title: Implement Selection Sort
localeTitle: Реализация выбора Сортировка
---
## Реализация выбора Сортировка

### Метод:

*   Выбор Сортировка - один из простых алгоритмов сортировки для понимания и реализации.
*   Этот алгоритм разбивает массив на две части:

1.  отсортированный
2.  несортированный

*   Сортированная часть находится в начале массива и затем не сортируется.
*   Каждый проход, сначала мы предполагаем, что первый элемент будет наименьшим, а затем мы перебираем весь массив и _выбираем_ наименьший элемент. В конце прохода мы обмениваем наименьший элемент на отсортированный массив.
*   Он имеет временную сложность **O (n 2 )** .

### Решение:

```js
function swap(a, b, arr){ 
  let tmp = arr[a]; 
  arr[a] = arr[b]; 
  arr[b] = tmp; 
 } 
 function selectionSort(array) { 
  for (let i = 0; i < array.length-1; i++){ 
    let min = i; 
    for (let j = i+1; j < array.length; j++){ 
      if (array[min] > array[j]) min = j; 
    } 
    swap(i, min, array); 
  } 
  return array; 
 } 
```

### Рекомендации:

*   Читайте о выборе Сортировка в [Википедии](https://en.wikipedia.org/wiki/Selection_sort)