---
title: Create a Controlled Input
localeTitle: Создание управляемого входа
---
## Создание управляемого входа

Здесь идея состоит в том, чтобы создать управляемый вход, где текст обновляется из вашего состояния, а не из браузера.

Итак, для начала у нас есть скелет, в котором у нас есть класс с именем `ControlledInput` и переменная состояния с именем `input` . Теперь все, что вам нужно сделать, это принять это состояние, и когда наблюдается изменение в окне ввода, запускается функция, которая изменяет значение внутри этого поля ввода и в абзаце ниже.

Таким образом, вы первый шаг будете делать функцию, которая изменяет `input` переменной состояния.
```
handleChange(event) { 
    this.setState({ 
      input: event.target.value 
    }); 
 } 
```

Теперь ваш следующий шаг будет включать создание окна ввода и запуск его, когда кто-то что-то набирает. К счастью, у нас есть событие, называемое `onChange()` для этой цели. PS - Вот еще один способ связать `this` с функцией
```
<input onChange = {this.handleChange.bind(this)}/> 
```

Но это не будет служить вашей цели. Хотя вы можете почувствовать, что это работает. Так что происходит здесь, это текстовые обновления из браузера, а не из состояния. Поэтому, чтобы исправить это, мы добавим атрибут `value` и установим его в `this.state.input` для элемента ввода, который заставит вход получить управляемый по состоянию.
```
<input value = {this.state.input} onChange = {this.handleChange.bind(this)}/> 
```

Это может быть немного сложно переварить, но чтобы сделать вещи более ясными, попробуйте удалить всю вещь `onChange` , чтобы ваш код выглядел так
```
<input value = {this.state.input}/> 
```

Теперь запустите тесты еще раз, можете ли вы ввести что-нибудь? Ответ на него будет «НЕТ», так как ваше поле ввода получает значение из `input` переменной состояния, так как нет изменений в `input` состояния (сначала пустая строка), что произойдет только при `handleChange()` функции `handleChange()` которая будет происходит только тогда, когда у вас есть обработчик событий, например `onChange()` поэтому строка внутри поля ввода останется такой, `onChange()` есть, т.е. пустая строка.