---
title: Introducing Inline Styles
localeTitle: Представление встроенных стилей
---
## Представление встроенных стилей

## Решение

Это может быть немного сложно, потому что JSX очень похож на HTML, но **не тот же** .

Давайте проведем шаги, чтобы вы поняли разницу. Сначала установите тэг стиля в **объект JavaScript** .

```react.js
class Colorful extends React.Component { 
  render() { 
    return ( 
      <div style={{}}> 
        Big Red 
      </div> 
    ); 
  } 
 }; 
```

Теперь у вас есть тег стиля, установленный на пустой объект. Обратите внимание, что есть два набора фигурных скобок. Это важное различие между JSX и HTML.

Во-вторых, давайте установим красный цвет.

```react.js
class Colorful extends React.Component { 
  render() { 
    return ( 
      <div style={{ color: 'red' }}> 
        Big Red 
      </div> 
    ); 
  } 
 }; 
```

Наконец, давайте установим размер шрифта в 72px.

### Спойлер

```react.js
class Colorful extends React.Component { 
  render() { 
    return ( 
      <div style={{ color: 'red', fontSize: '72'}}> 
        Big Red 
      </div> 
    ); 
  } 
 }; 
```

Обратите внимание, что атрибут JSX - это **camelCase** . Это еще одно важное отличие, чтобы помнить о JSX. Кроме того, вы, вероятно, заметили, что нет единицы. В JSX при настройке атрибута fontSize **блок является необязательным** и автоматически устанавливается в px, если он не задан вручную.