---
title: Use @for to Create a Sass Loop
localeTitle: Используйте @ для создания петли Sass
---
## Используйте @ для создания петли Sass

1.  Основной синтаксис цикла `@for` в SASS:

*   Проходной цикл:

```sass
@for $i from <start number> through <end number> { 
  // some CSS 
 } 
```

*   For-to loop:

```sass
@for $i from <start number> to <end number> { 
  // some CSS 
 } 
```

Обратите внимание, что основное отличие состоит в том, что «начало к концу» **исключает** конечный номер, а «начальный конец» **включает** конечный номер.

2.  Например:

*   Проходной цикл:

```sass
@for $i from 1 through 3 { 
  // some CSS 
 } 
 
 // 1 2 
```

*   For-to loop:

```sass
@for $i from 1 to 3 { 
  // some CSS 
 } 
 
 // 1 2 3 
```

3.  Руководящий [принцип](https://sass-guidelin.es/#loops) от [SASS Guideline](https://sass-guidelin.es/#loops)

Цикл `@for` может быть полезен в сочетании с CSS `:nth-*` псевдоклассы. За исключением этих сценариев, предпочитайте цикл `@each` если вам нужно перебирать что-то.

```sass
@for $i from 1 through 10 { 
  .foo:nth-of-type(#{$i}) { 
    border-color: hsl($i * 36, 50%, 50%); 
  } 
 } 
```

Всегда используйте `$i` как имя переменной, чтобы придерживаться обычного соглашения, и если у вас нет по-настоящему веской причины, никогда не используйте ключевое слово: всегда используйте. Многие разработчики даже не знают, что Sass предлагает этот вариант; использование этого может привести к путанице.

Также не забудьте соблюдать эти рекомендации для сохранения читаемости:

*   Всегда пустая новая строка перед `@for` ;
*   Всегда пустая новая строка после закрывающей скобки (}), если следующая строка не является закрывающей скобкой (}).