---
title: Chaining If Else Statements
localeTitle: Связывание с другими сообщениями
---
## Связывание с другими сообщениями

*   `If` : первое условие в каждом операторе if / else, в случае, если условие _истинно_ , выполните код и проигнорируйте остальные.
*   `Else if` : никогда нельзя использовать в качестве первого условного. Он всегда является условным после того, как `if` , если условие истинно, выполните код. В противном случае переходит в следующее условие.
*   `Else` : case все предыдущие условные _выражения_ являются _ложными_ , **иначе** выполняется.

### Объяснение проблемы:

_Записывать прикованные `if` / `else if` выражения для выполнения следующих условий_ :

_`num < 5` - возвращение "Tiny" `num < 10` - возврат "Small" `num < 15` - возврат "Средний" `num < 20` - возврат "Большой" `num >= 20` - возврат "Огромный"_

#### Подсказка 1

Помните, что вы можете комбинировать (цепочки) несколько `if...else` операторов один за другим, пока ваш последний не использует `else if (condition) {do this}` .

> _попытаться решить проблему сейчас_
> 
> #### Подсказка 2
> 
> Иногда, когда вы пишете больше кода, чем вы привыкли, и он не работает, мелочи - вот что нас предает. Проверка недостающих точек с запятой, скобок и т. Д. Может оказаться очень полезной. _попытаться решить проблему сейчас_

## Осторожно, спойлеры!

**Решение впереди!**

## Решение:

```javascript
function testSize(num) { 
  // Only change code below this line 
  if (num < 5){ 
    return "Tiny"; 
  } 
  else if (num < 10) { 
    return "Small"; 
  } 
  else if (num < 15){ 
    return "Medium"; 
  } 
  else if (num < 20){ 
    return "Large"; 
  } 
  else { 
    return "Huge"; 
  } 
  // Only change code above this line 
 } 
```

· Запустить код в [repl.it](https://repl.it/@AdrianSkar/Basic-JS-Chaining-ifelse-statements)

### Обозначение кода

Функция сначала проверяет условие `if` `(num < 5)` . Если он оценивает значение `true` , он возвращает выражение между фигурными фигурными скобками («Tiny»). Если это не так, оно проверяет следующее условие до последнего оператора `else` .

### Ресурсы

*   ["if ... else" - _ссылка MDN JavaScript_](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/if…else)