---
title: Selecting from Many Options with Switch Statements
localeTitle: Выбор из многих параметров с помощью операторов Switch
---
## Выбор из многих параметров с помощью операторов Switch

_Если у вас есть много вариантов на выбор, используйте оператор `switch` . Оператор `switch` проверяет значение и может иметь множество операторов `case` которые определяют различные возможные значения. Заявления выполняются из первого совпадающего значения `case` до тех пор, пока не будет обнаружен `break` ._

_Вот пример псевдокода:_

```js
  switch(num) { 
    case value1: 
      statement1; 
      break; 
    case value2: 
      statement2; 
      break; 
    ... 
    case valueN: 
      statementN; 
      break; 
  } 
```

### Немного больше объяснений

Оператор switch сначала оценивает свое выражение. Затем он ищет предложение первого `case` , выражение которого оценивается с тем же значением, что и результат входного выражения (используя [строгое сравнение](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Comparison_Operators) , ( `===` ) и передает управление этому предложению, выполняя связанные операторы (если несколько совпадений совпадают предоставленное значение, выбирается первый случай, который соответствует, даже если случаи не равны друг другу.)

Если `case` не найден, программа ищет необязательное предложение по `default` , и если оно найдено, передает управление этому предложению, выполняя связанные операторы. Если предложение по `default` не найдено, программа продолжает выполнение в инструкции после окончания `switch` . По соглашению, предложение по `default` является последним предложением, но это не обязательно так.

Необязательный оператор `break` связанный с каждым ярлыком case, гарантирует, что программа выйдет из коммутатора после выполнения согласованного оператора и продолжит выполнение в операторе следующего коммутатора. Если `break` пропущен, программа продолжает выполнение в следующем выражении в инструкции `switch` . [1](#cite1)

### Проблема Объяснение:

_Напишите оператор switch, который проверяет `val` и устанавливает `answer` для следующих условий:_

*   `1` - «альфа»,
*   `2` - «бета»,
*   `3` - «гамма»,
*   `4` - «дельта».

## Подсказка 1

Помните, что значения `case` проверяются со строгим равенством ( `===` ).

> Попробуйте решить проблему сейчас!

## Подсказка 2

Не видите _«следующие условия»_ как упорядоченный список, как он выглядит в оригинальной демонстрации freeCodeCamp, но как значения и инструкции, как показано здесь

> Попробуйте решить проблему сейчас!

## Осторожно, спойлеры!

### Вы полностью уверены, что хотите посмотреть? ...

## Решение базового кода

```js
function caseInSwitch(val) { 
  var answer = ""; 
  // Only change code below this line 
  switch(val) { 
    case 1: 
      return "alpha"; 
      break; 
    case 2: 
      return "beta"; 
      break; 
    case 3: 
      return "gamma"; 
      break; 
    case 4: 
      return "delta"; 
      break; 
  } 
 
  // Only change code above this line 
  return answer; 
 } 
 
 // Change this value to test 
 caseInSwitch(1); 
```

### Обозначение кода

Обычно игнорируется, что значения `case` проверяются со строгим равенством с любой потребностью другого выражения, например: `case === value`

## Альтернативное решение для кода:

```javascript
function caseInSwitch(val) { 
  var answer = ""; 
  // Only change code below this line 
  switch (val){ 
    case 1: 
      answer="alpha"; 
      break; 
    case 2: 
      answer="beta"; 
      break; 
    case 3: 
      answer="gamma"; 
      break; 
    case 4: 
      answer="delta"; 
      break; 
  } 
  // Only change code above this line 
  return answer; 
 } 
 // Change this value to test 
 caseInSwitch(1); 
```

· Запустить код в [repl.it.](https://repl.it/@AdrianSkar/Basic-JS-Switch-statements)

### Обозначение кода

Поскольку у вас уже есть переменная, определенная в начале функции с именем `answer` и она определена как последний оператор return, вы можете назначить ему новые значения для каждого случая и вернет ожидаемый ответ в зависимости от значения, которое вы передаете функции.

### источники

1 . [Описание «switch» - _ссылка MDN JavaScript_](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/switch#Description) .