---
title: Prevent Infinite Loops with a Valid Terminal Condition
localeTitle: Предотвращение бесконечных циклов с допустимым условием терминала
---
## Предотвращение бесконечных циклов с допустимым условием терминала

*   Чтобы предотвратить бесконечный цикл, `while-condition` должно достигнуть терминального условия выхода из цикла.
*   Таким образом, ошибка в этой задаче возникает из-за условия - `i != 4` - в цикле for.
*   Если вы внимательно рассмотрите код:

```javascript
function myFunc() { 
  for (let i = 1; i != 4; i += 2) { 
    console.log("Still going!"); 
  } 
 } 
```

*   Вы увидите, что `i` сначала инициализируется как 1, и после каждой итерации цикла `i` увеличивается на 2.
*   Используя эту логику, после первой итерации - `i = 3` и второй итерации `i = 5` условие `i != 4` никогда не будет выполнено, и произойдет бесконечный цикл.

## Решение:

```javascript
function myFunc() { 
  for (let i = 1; i <= 4; i += 2) { 
    console.log("Still going!"); 
  } 
 } 

```