---
title: Use getters and setters to Control Access to an Object
localeTitle: Использовать геттеры и сеттеры для контроля доступа к объекту
---
## Использовать геттеры и сеттеры для контроля доступа к объекту

Геттеры и сеттеры являются критическими частями класса / объекта. Они позволяют вам контролировать свои атрибуты извне. Они станут более заметными, когда вы начнете работу с объектно-ориентированным модулем программирования (вверх!). Пока это упражнение показывает вам, как манипулировать ими с ES6.

## Подсказка 1:

Создайте класс, Термостат. Здесь вы поместите свой конструктор, геттер и сеттер.

## Подсказка 2:

Дайте конструктору параметр (который вы можете назвать чем угодно). Установите параметр в атрибут с тем же именем. Помните, что вы изначально устанавливаете вещи в температуре Фаренгейта.

## Подсказка 3:

Создайте метод get, который преобразует атрибут Farenheit в Celsius. Используйте формулу, предоставленную вам.

## Подсказка 4:

Создайте метод с тем же именем, что и метод get. Он должен иметь параметр, который принимает температуру Цельсия. Преобразуйте его в farenheit и установите его в атрибут.

## Оповещение о спойлере - решение впереди!

## Решение

```javascript
function makeClass() { 
  "use strict"; 
  /* Alter code below this line */ 
 
  class Thermostat{ 
    constructor(farenheit){ 
      this.farenheit = farenheit; 
    } 
    get temperature(){ 
      return 5 / 9 * (this.farenheit - 32); 
    } 
    set temperature(celsius){ 
      this.farenheit = celsius * 9.0 / 5 + 32; 
    } 
  } 
 
  /* Alter code above this line */ 
  return Thermostat; 
 } 

```