---
title: Understand Functional Programming Terminology
localeTitle: Понять терминологию функционального программирования
---
## Понять терминологию функционального программирования

### метод

Как и в последнем вызове, вы должны вызвать метод `getTea` и сохранить его в переменной. Только на этот раз у вас есть 2 переменных для хранения 2 отдельных наборов данных. Вы увидите, что `getTea()` такая же, как и раньше, только теперь она принимает 2 отдельных параметра. Первый параметр - это функция, поэтому нам нужно передать либо `prepareGreenTea()` либо функцию `prepareBlackTea()` , за которой следует второй параметр `numOfCups` который может быть `numOfCups` как целое число.

### Решение

В этом упражнении мы назначаем результат функции более высокого порядка для переменных. Для этого мы вызываем функцию с функцией обратного вызова в качестве параметра.

## Подсказка:

`javascript const basketOne = makeBasket(addFruit, 10)`

\## Решение:

\`\` \`Javascript

/ \*\*

*   Длительный процесс приготовления зеленого чая.
*   @return {string} Чашка зеленого чая. \*\* / const prepareGreenTea = () => 'greenTea';

/ \*\*

*   Получите заданное количество чашек чая.
    
*   @param {function (): string} prepareTea Тип функции приготовления чая.
    
*   @param {number} numOfCups Количество необходимых чашек чая.
    
*   @return {Array } Количество чайных чашек. \*\* / const getTea = (prepareTea, numOfCups) => { const teaCups = \[\];
    
    для (пусть cups = 1; cups <= numOfCups; чашки + = 1) { const teaCup = prepareTea (); teaCups.push (Teacup); }
    
    return teaCups; };
    
    // Добавьте код ниже этой строки const tea4GreenTeamFCC = getTea (prepareGreenTea, 27); // :) const tea4BlackTeamFCC = getTea (prepareBlackTea, 13); // :) // Добавьте код выше этой строки
    
    console.log ( tea4GreenTeamFCC, tea4BlackTeamFCC );
    
    \`\` \`
    

## Обозначение кода:

В вышеприведенном решении мы передали функции `prepareGreenTea()` и `prepareBlackTea()` качестве параметров или функций обратного вызова для функций `getTea()` , назначаемых нашим двум постоянным переменным `tea4BlackTeamFCC` и `tea4GreenTeamFCC` . Таким образом, глобальные переменные не изменяются, и мы можем добавить неограниченное количество различных вариантов методов `prepareTea()` поскольку это функция обратного вызова, передаваемая функции `getTea()` порядка `getTea()` .