---
title: Use Closure to Protect Properties Within an Object from Being Modified Externally
localeTitle: Использовать закрытие для защиты свойств внутри объекта от модификации извне
---
## Использовать закрытие для защиты свойств внутри объекта от модификации извне

### метод

Как и в приведенном примере, вместо объявления переменной `weight` с `this` ключевым словом, ключевое слово `let` должно использоваться для объявления его как частной переменной. Таким образом, доступ к ней возможен только внутри функции `Bird` . Метод `getWeight` должен быть добавлен в функцию `Bird` для доступа к переменной `weight` .

### Решение

```javascript
function Bird() { 
  let weight = 15; 
 
  this.getWeight = function() { 
    return weight; 
  }; 
 
 } 

```