---
title: Match Single Characters Not Specified
localeTitle: Совпадение отдельных символов не указано
---
## Совпадение отдельных символов не указано

В этой задаче нам предлагается вернуть набор совпадений, которые точно не указаны. Если предыдущие проблемы с регулярным выражением совпадали бы в случае с символом \[az\], эта задача вместо этого просит нас отрицать эти совпадения с использованием символа каретки \[^ az\]. Наша цель состоит в том, чтобы вернуть отрицательную коллекцию (не совпадение) букв, которые не являются гласными или номерами.

## Подсказка 1:

Не помните, чтобы вы окружали ваше регулярное выражение как в квадратных скобках, так и в косе?

```javascript
let exampleRegExp = /[^az]/; 
```

Если да, то дважды проверьте, что вы добавляете соответствующие флаги:

*   i: Игнорирует верхний и нижний регистр из поиска / соответствия
*   g: извлекает несколько значений; default установлен для возврата первого совпадения, которое он встречает
*   ^: Отрицает совпадения после этого флага

### Подсказка 2:

Не забудьте проверить правильность номера вашего номера - проблема требует от нас отрицания всех чисел от 0 до 99. Это можно сделать с помощью каретки negate, помещенной сразу после первой открытой скобки вашего регулярного выражения.

```javacsript
let numbersRegExp = /[^0-99]/ig; 
```

### Предупреждение о спойлере - решение впереди

## Решение

```javascript
let quoteSample = "3 blind mice."; 
 let myRegex = /[^aeiou^0-99]/ig; // Change this line 
 let result = quoteSample.match(myRegex); // Change this line 

```