---
title: Positive and Negative Lookahead
localeTitle: Положительный и отрицательный Lookahead
---
## Положительный и отрицательный Lookahead

*   Помните, чтобы использовать 2 `lookaheads` для проверки шаблонов в строке. Первый `lookahead` очень похож на тот, который приведен в примере - '(? = \\ W {3,6})' - только `lower-number` 3 слишком низкое для наших тестовых случаев, а `upper-number` совершенно неудобно. Этот первый `lookahead` используется только для поиска строки, состоящей из определенного количества символов. Для проверки последовательных числовых значений в конце строки необходимо использовать второй `lookahead` .
    
*   Второй `lookahead` также аналогичен приведенному в примере - `(?=\D*\d)` - однако это выражение также должно быть изменено для прохождения всех тестовых случаев. Не забудьте указать точное количество номеров, которые вы хотите отобразить в конце строки.
    

## Решение :

```javascript
let sampleWord = "astronaut"; 
 let pwRegex = /(?=\w{5,})(?=\D*\d{2})/; 
 let result = pwRegex.test(sampleWord); 

```