---
title: Restrict Possible Usernames
localeTitle: Ограничить возможные имена пользователей
---
## Ограничить возможные имена пользователей

## Решение:

```javascript
let username = "JackOfAllTrades"; 
 let userCheck = /^[az]{2,}\d*$/i; 
 let result = userCheck.test(username); 
```

## Объясните:

1.  Единственные числа в имени пользователя должны быть в конце. `\d$` В конце может быть ноль или более. `*`

```javascript
/\d*$/; 
```

2.  Буквы пользователя могут быть строчными и прописными. `i`

```javascript
/\d*$/i; 
```

3.  Имена пользователей должны иметь длину не менее двух символов. `{2,}` Двухбуквенное имя пользователя может использовать только буквы алфавита. `^[az]`

```javascript
/^[az]{2,}\d*$/i; 

```