---
title: Add Rounded Corners with border-radius
localeTitle: Добавить закругленные углы с граничным радиусом
---
## Добавить закругленные углы с граничным радиусом

Иногда вы хотите иметь закругленные углы вместо квадратных. В этом случае мы используем свойство border-radius для определения того, насколько округлены мы хотим, чтобы наши углы были.

Чтобы настроить округлость угла, используйте:

```css
.example { 
 border-radius: 5px; 
 } 
```

Чем выше число, тем больше за углом.

```css
.example { 
 border-radius: 20px; 
 } 
```

Используя свойство border-radius, мы можем окружать углы нашего элемента, независимо от того, означает ли это округление границы, фоновое изображение или цвет заливки самого элемента. Вы заметите только новые закругленные углы, если есть изменение цвета!

Если вы включаете только один номер, этот радиус будет применен ко всем четырем углам. Если вы используете два значения, первый применяется к верхним левым и нижним правым углам, а второй - к верхнему правому и нижнему левому.

```css
.exampleTwoValues { 
 border-radius: 5px 10px; 
 } 
```

Если вы используете четыре значения, значения применяются к верхнему левому, верхнему правому, нижнему правому и нижнему левому краю.

```css
.exampleFourValues { 
 border-radius: 5px 7px 10px 15px; 
 } 
```

Если вы используете три значения, первое относится к верхнему левому, второе относится к верхнему правому и нижнему левому, а третье относится к нижнему праву.

```css
.exampleThreeValues { 
 border-radius: 5px 10px 15px; 
 } 

```