---
title: Cascading CSS Variables
localeTitle: Каскадные переменные CSS
---
## Каскадные переменные CSS

Каскадные переменные CSS, официально называемые пользовательскими свойствами, являются объектами, которые ведут себя аналогично традиционным переменным. В том , что переменные позволяют хранить данные и обновляться , чтобы отражать новые значения позже 2.

Переменные CSS определены, чтобы содержать определенные значения и использоваться повторно в документе. Они устанавливаются с использованием пользовательской `--main-color: black` свойств (например, `--main-color: black` ) и доступны с помощью функции `var()` (например, `color: var(--main-color)` ) 1 . Объявите переменную CSS в селекторах `:root` или `body` для глобального доступа.

При сохранении сложных документов CSS полезно не только использовать переменные CSS, но и умные. При создании будущих обновлений вместо поиска потенциальных сотен строк кода нужно только обновить необходимую переменную CSS 1 .

### Синтаксис

```css
:root { 
  --main-bkgnd-color:  #00B8CB; 
 } 
 
 body { 
  background-color: var(--main-bkgnd-color); 
  font-family: 'Raleway', Helvetica, sans-serif; 
 } 
```

Объявление переменной:

```css
--custom-name: value 
```

Использование переменной: `css var(--custom-name)`

### источники

1.  [Посетите страницу каскадных CSS-переменных MDN для получения дополнительной информации.](https://developer.mozilla.org/en-US/docs/Web/CSS/Using_CSS_variables)
2.  [Перна, Мария Антониетта. «Практическое руководство по CSS переменных (Пользовательские свойства)» _SitePoint._ 01 августа 2018. Доступ: 5 октября 2018 г.](https://www.sitepoint.com/practical-guide-css-variables-custom-properties/)