---
title: Override Styles in Subsequent CSS
localeTitle: Переопределить стили в последующем CSS
---
## Переопределить стили в последующем CSS

Самый важный бит, который следует помнить при необходимости переопределять стили в последующем CSS, - это порядок создания классов.

Последний обновленный стиль будет иметь прецедент над ранее написанными классами.

Например:

```html

<style> 
  body { 
    color: purple; 
  } 
  .red-text { 
    color: red; 
  } 
  .blue-text { 
    color: blue; 
  { 
 </style> 
```

Теперь, когда вы создаете какой-либо текст в `body` , он будет иметь назначенный ему цвет текста `purple` .

Чтобы начать экспериментировать с процессом переопределения, теперь вы можете добавить класс `"red-text"` чтобы увидеть результаты.

Используя вышеприведенный формат, текст ниже переопределяет ранее `purple` цвет шрифта с `red` .

```html

<h1 class="red-text">Example</h1> 
```

Если вы хотите добавить несколько классов, вы можете использовать этот формат:

```html

<h1 class="class-name1 class-name2 class-name3">Example</h1> 
```

Теперь вы можете добавить последний класс, созданный выше ( `"blue-text"` ), в тот же пример выше, чтобы увидеть результаты.

```html

<h1 class="red-text blue-text">Example</h1> 
```

Это автоматически выберет последний класс, созданный в разделе стилей, который в этом случае был `"blue-text"` .

Даже если вы применяете `red-text` -го класса за `blue-text` второго класса, процесс переопределения будет выбирать последний созданный класс. В этом случае этот класс является `blue-text` .

Так, например:

```html

<h1 class="blue-text red-text">Example</h1> 
```

Это все равно отобразит `blue` цвет шрифта из-за упорядочивания в разделе стилей.

Класс `blue-text` был создан последним, торчащим снизу ( `</style>` ).