---
title: Amazon DynamoDB
localeTitle: Amazon DynamoDB
--- ## Amazon DynamoDB

Amazon DynamoDB - это сервис от Amazon Web Services (AWS), который предлагает полностью управляемую базу данных NoSQL. Его основной особенностью является способность масштабироваться бесконечно в зависимости от требуемой рабочей нагрузки. Он полностью управляется, пользователю не нужно беспокоиться о базовой инфраструктуре, например о масштабировании вверх или вниз в зависимости от рабочей нагрузки. Он поддерживает хранение данных на основе ключей и документов.

Основными компонентами службы DynamoDB являются:

*   **Таблица** : DynamoDB хранит данные в таблицах, которые похожи на реляционные базы данных. Главное отличие состоит в том, что она схематична, она не имеет фиксированной структуры с момента ее создания.
    
*   **Элемент** : Элемент - это данные, хранящиеся в таблице, а таблица может иметь неопределенное количество элементов. По сравнению с реляционной базой, элемент будет представлять собой строку в таблице.
    
*   **Атрибут** : элемент имеет атрибуты, похожие на столбцы в реляционных базах данных. Тем не менее, поскольку DynamoDB является схематичным, элемент не должен иметь одинаковые атрибуты. Более того, атрибуты могут быть одним значением или JSON-подобным документом с другими полями, которые также могут быть запрошены.
    

Хотя DynamoDB не нуждается в фиксированной структуре для своих таблиц, для этого необходим первичный ключ для каждого элемента таблицы. Первичный ключ, как и в реляционных базах данных, должен быть уникальным. Первичный ключ может быть простым или составленным. Простой первичный ключ состоит только из ключа раздела. Скомпилированный первичный ключ, в свою очередь, состоит из ключа раздела и ключа сортировки. В простом первичном ключе ключ раздела должен быть уникальным, а в скомментированном ключе ключ раздела может быть равен, но ключ сортировки должен быть другим.

Концепция ключа раздела и ключа сортировки очень важна, поскольку она связана с тем, как DynamoDB хранит данные. DynamoDB хранит данные в разделах, а ключ раздела - это ключ для раздела. DynamoDB использует значение в ключе раздела в качестве входа хеш-функции, чтобы знать, где он хранит данные. В случае сложенного ключа все элементы с одним и тем же ключом раздела хранятся в одном разделе, но сортируются по типу сортировки.

Amazon DynamoDB также имеет высокую доступность. Он реплицирует данные на многие серверы в разных зонах доступности в регионе. Зоны доступности - это центры обработки данных, физически разделенные безопасным расстоянием. В случае бедствия на одном сервере другие серверы реплицируются на безопасном расстоянии и нетронутыми.

Благодаря простоте настройки и бесконечной емкости для масштабирования это хорошо для многих случаев использования. Он лучше всего подходит для сценариев, где требуемая нагрузка неизвестна или появляются внезапные пики. Некоторые из вариантов использования - это хранилище данных для серверных приложений, микросервисов, мобильных back-end, игр, IoT и других.

### Ресурсы:

*   [Базы данных ключевых значений](https://guide.freecodecamp.org/computer-science/databases/key-value-databases)
*   [Реляционные базы данных](https://guide.freecodecamp.org/computer-science/databases/relational-databases)

### Дополнительная информация:

*   «Что такое Amazon DynamoDB?» из [документации AWS DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Introduction.html?shortFooter=true)
*   «Основные компоненты DynamoDB» из [документации AWS DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.CoreComponents.html?shortFooter=true)