---
title: Amazon Web Services
localeTitle: Веб-службы Amazon
---
## Веб-службы Amazon

Amazon Web Services, или AWS для краткости, является дочерней компанией Amazon.com, которая предоставляет платформы облачных вычислений по требованию для отдельных лиц, компаний и правительств на платная подписка с возможностью бесплатного доступа на 12 месяцев. Он наряду с Microsoft Azure и облачной платформой Google считается тремя основными поставщиков публичных облаков.

Эта технология позволяет абонентам иметь в своем распоряжении полноценный виртуальный кластер компьютеров, доступный все время через Интернет. Версия AWS виртуальные компьютеры имеют большинство атрибутов реального компьютера, включая аппаратное обеспечение (CPU (процессоры) и GPU (ы) для обработки, локальную / оперативную память, жесткий диск / SSD-накопитель); Выбор операционных систем; сетей; и предварительно загруженное прикладное программное обеспечение, такое как веб-серверы, базы данных, CRM и т. д. Каждая система AWS также виртуализирует свой консольный ввод-вывод (клавиатура, дисплей и мышь), позволяя абонентам AWS подключаться к их системе AWS из любой точки мира, используя современный браузер. Браузер действует как окно в виртуальный компьютер, позволяя подписчикам войти в систему, настроить и использовать свои виртуальные системы так же, как и реальный физический компьютер.

Подписчики могут использовать свои системы AWS для предоставления интернет-услуг для своих собственных и своих клиентов. Поскольку отдельные лица или организации использование AWS физически не владеет инфраструктурой AWS, им не приходится решать некоторые задачи обслуживания, связанные с владением физическим центром данных, таким как операционное сетевое оборудование.

AWS, в частности, также расширяет свои облачные предложения. Они предоставляют инновационные услуги, такие как AWS Lambda, в которых пользователям нужно сосредоточиться только на написания кода, а не на серверах, которые будут запускать свой код (что приводит к новому _безсерверному_ движению). В результате этих преимуществ облачные вычисления такие платформы, как AWS, были популярны среди стартапов, которые изначально могут иметь меньше капитала для инвестиций в свои информационные технологии или ИТ. Вместо этого они могут сосредоточиться по созданию отличных продуктов для своих пользователей и развитию своего бизнеса с течением времени с помощью модели AWS по требованию.

Популярные услуги AWS включают:

*   Виртуальные машины через платформу EC2 (Elastic Compute Cloud)
*   Базы данных, включая SQL и NoSQL
*   S3 (простая служба хранения)
*   SQS (Simple Queue Service)
*   Разработка игр с помощью механизма разработки игр Amazon Lumberyard и последующей платформы для хостинга.
*   DynamoDB (База данных динамов Амазонки)
*   CloudWatch (метрики и сигналы)
*   CodeDeploy (развертывание)
*   Лямбда (без сервера)
*   Инструменты мониторинга приложений
*   Мобильные инструменты и платформы для разработки
*   Область разработки Amazon Alexa

#### Сертификаты AWS

AWS предлагает множество различных сертификатов для своих практиков. Существуют различные уровни для сертификатов AWS, а также сертификаты на основе ролей. Уровни:

*   основополагающие
*   ассоциированный
*   профессиональный Для каждой роли есть три уровня.

Эти роли включают:

*   Архитектор
*   разработчик
*   операции

AWS также предлагает предварительную сертификацию AWS Cloud Practitioner Essentials \*, относящуюся к любому независимо от их роли. Вне стандартных ролей есть специальные сертификаты для расширенных сетей, больших данных и безопасности.

#### Дополнительная информация:

*   [AWS](https://aws.amazon.com/)
*   [сертификаты](https://aws.amazon.com/certification/)