---
title: Internet Applications
localeTitle: Интернет-приложения
---
## Интернет-приложения

![Технологические слои](https://upload.wikimedia.org/wikipedia/commons/9/9f/Linux_kernel_and_Computer_layers.png)

### обзор

Интернет-приложения - это приложения, которые разрешены подключением локального устройства к удаленному серверу приложений или облачным службам. Интернет-приложения работают на настольных компьютерах и тонких клиентах, таких как смарт-устройства и другие интернет-устройства. Настольные компьютеры обычно используют веб-браузеры для облегчения подключения. Умные устройства используют либо веб-браузер, либо специальное приложение или Rich Internet Application. Веб-приложения - это своего рода интернет-приложение.

### Полный стек

Интернет-приложения состоят из полного набора слоев. Стек иногда делится на две части или слои: передний и задний. Однако стек разделен, приложение состоит из уникального для себя программного обеспечения и множества зависимых программ. Зависимое программное обеспечение состоит из библиотек и другого программного обеспечения, предоставляющего услуги.

### Полный стек как система подсистем

Полезный способ просмотра каждого компонента является частью системы подсистем, где каждая подсистема представляет собой систему подсистем. В качестве аналогии человеческое тело представляет собой систему подсистем. Тело имеет иммунную подсистему, пищеварительную подсистему, нервную подсистему, скелетную подсистему, мышечную подсистему и тому подобное. Например, пищеварительная система включает подсистему печени, например, «печень». Каждая подсистема представляет собой систему в своей области деятельности или функции.

### Передняя часть стека

«Front End» - это программное обеспечение, уникальное для приложения, которое выполняет работу на локальном устройстве. Локальное устройство имеет все функциональные компоненты компьютера. программные приложения, установленные в операционной системе, работающей на оборудовании (или виртуальном оборудовании, работающем на аппаратном или другом виртуальном оборудовании).

### Задний конец стека

«Back End» - это программное обеспечение, уникальное для приложения, которое выполняет работу на удаленном сервере. На удаленном сервере есть все функциональные компоненты компьютера: программные приложения, установленные в операционной системе, работающей на аппаратном обеспечении (или виртуальном аппаратном обеспечении, работающем на аппаратном или другом виртуальном оборудовании).

### Смещение приложения к переднему или заднему концу

Приложения, стремящиеся последовательно работать на разных устройствах или требующие безопасности при хранении и доступе к данным, будут иметь большую логику бизнеса в задней части. Это связано с тем, что программное обеспечение на лицевой стороне подвержено многим другим способам атаки от вредоносных агентов, таких как вирусы, вредоносные программы и инсайдерские угрозы, а также «внутренние хакеры». Кроме того, веб-браузеры стандартизируют рендеринг веб-контента, отправленного на передний план.

Приложения, требующие быстрого и эффективного использования ресурсов проекта, перемещают как можно больше программного обеспечения в Front End. Перемещая ресурсы в Front End, проект может делиться своими ограниченными ресурсами Back End с большим количеством конечных пользователей.

### Сервер приложений

Сервер приложений или программная среда обеспечивает основные требуемые зависимости для интернет-приложения.

### Дополнительная информация:

[Бесплатная сертификация разработки FreeCodeCamp](https://guide.freecodecamp.org/meta/free-code-camp-full-stack-development-certification)

[Богатое интернет-приложение (Wikipedia.org)](https://en.wikipedia.org/wiki/Rich_Internet_application)

[Рамки программного обеспечения (Wikipeida.org)](https://en.wikipedia.org/wiki/Software_framework)

[Рамки веб-приложений (Wikipedia.org)](https://en.wikipedia.org/wiki/Web_framework)

[Сервер приложений (Wikipedia.org)](https://en.wikipedia.org/wiki/Application_server)