---
title: CPU
localeTitle: ЦПУ
---
## ЦПУ

Центральный процессор (CPU) служит «мозгом» компьютера, что позволяет ему выполнять важные вычислительные задачи.

ЦП - это интегральные схемы, которые представляют собой сложные схемы, встроенные в один чип. Они включают регистры, в которых хранятся отдельные значения, и контакты ввода / вывода. Эти контакты позволяют им разговаривать с остальной частью компьютера. Из-за продолжающегося продвижения технологии процессора многие компьютеры сегодня используют многопроцессорную систему. Мультипроцессоры - это одиночные чипы, которые содержат два или более процессора или «ядра», которые позволяют увеличить возможности обработки.

Скорость процессора измеряется в гигагерцах (ГГц). Для каждого гигагерца скорости процессор может выполнить один миллиард инструкций за секунду. Эти инструкции очень просты, например «добавить два числа» или «переместить эту переменную в это место». Чтобы увидеть это в действии, прочитайте об [ассемблере](https://en.wikipedia.org/wiki/Assembly_language) .

Gigahertz - не единственный определяющий фактор в фактической скорости процессора, поскольку разные процессоры с одинаковой скоростью гигагерца (также известные как тактовая частота) могут выполнять реальные задачи на разных скоростях из-за использования разных наборов инструкций для выполнения этих задач , Эти наборы команд называются архитектурами ЦП.

Большинство современных процессоров используют 64-битную архитектуру, что означает, что они используют 64-разрядные адреса памяти. Старые процессоры использовали 32-разрядные, 16-разрядные и даже 8-битные архитектуры. Наибольшее число, которое может хранить 64-битный процессор, составляет 18 446 744 073 709 552 000. CPU нуждается в адресах памяти для получения заданных значений из ОЗУ. Если мы будем называть длину адресов памяти n, 2 ^ n - количество ячеек памяти, к которым может обратиться ЦП.

Цикл команд для CPU называется циклом цикла-выборки-декодирования - когда компьютер извлекает инструкцию из своей памяти, определяет, какую команду он извлекает и что он делает, а затем выполняет указанные инструкции.

Возможно, наиболее распространенной проблемой, влияющей на процессор, является неадекватное охлаждение. ЦП являются основными генераторами тепла в компьютерных системах. По своей природе они обычно расположены под компьютерным вентилятором. Существуют различные способы снижения тепла в компьютере с двумя основными системами: воздушными вентиляторами или жидкостными системами охлаждения. Надлежащее техническое обслуживание тепла и дополнительное оборудование могут позволить правильно сконфигурированному процессору работать лучше, чем оцененный производителем чипа (он же «Разгон»).

**функция**

Микропроцессор представляет собой кремниевую микросхему, содержащую миллионы микроскопических транзисторов. Этот чип функционирует как мозг компьютера. Он обрабатывает инструкции или операции, содержащиеся в исполняемых компьютерных программах. Вместо того, чтобы выполнять инструкции непосредственно с жесткого диска, процессор берет свои инструкции из памяти. Это значительно увеличивает скорость компьютера.

**Производители компьютерных микропроцессоров**

Существует два основных производителя компьютерных микропроцессоров. Intel и Advanced Micro Devices (AMD) ведут рынок с точки зрения скорости и качества. Настольные процессоры Intel включают Celeron, Pentium и Core. Настольные процессоры AMD включают Sempron, Athlon и Phenom. Intel выпускает процессоры Celeron M, Pentium M и Core для ноутбуков. AMD выпускает мобильные версии своего Sempron и Athlon, а также мобильный процессор Turion, который поставляется в версиях Ultra и Dual-Core. Обе компании производят как одноядерные, так и многоядерные процессоры.

#### Дополнительная информация:

[Википедия](https://en.wikipedia.org/wiki/Central_processing_unit)
