---
title: GPU
localeTitle: GPU
---
## GPU

Графический процессор - графический процессор. Большинство компьютеров используют их для рендеринга видео или воспроизведения видеоигр.

Графический процессор похож на процессор, но имеет разные сильные и слабые стороны. Процессоры очень хорошо справляются с несколькими задачами очень быстро. Графические процессоры намного лучше работают одновременно с множеством задач, но медленнее. На типичном графическом процессоре может работать более 10 000 задач, но для запуска множества задач одновременно необходимо обмениваться памятью и другими ресурсами. Графические процессоры обычно запускают очень повторяющиеся задачи снова и снова, чтобы экономить процессор от потери времени. Некоторые процессоры имеют встроенные графические процессоры, но наличие отдельного графического процессора почти всегда более мощное.

Графические процессоры могут использоваться для вычисления, а также для рендеринга видео. Обычные способы сделать это включают OpenACC, CUDA, OpenCL и OpenGL. Некоторые приложения включают в себя реализации графического процессора, чтобы сократить время, которое приложение выполняет для запуска.

Графический процессор первоначально использовался в основном для 3D-рендеринга для улучшения разрешения и частоты кадров. Но теперь эти возможности более широко используются для улучшения вычислительных нагрузок во многих областях; например, финансовое моделирование, передовые научные исследования и разведка нефти и газа. Графические процессоры также используются в качестве ресурса для разработки биткойнов, поскольку они могут легко запускать повторяющиеся задачи, не напрягая ресурсы процессора, что позволяет запускать операционную систему на компьютере с низкопроизводительным процессором, все еще имея возможность использовать биткойн использование графического процессора

Есть два крупных бренда, выпускающих графические процессоры: NVidia и AMD. Их часто называют «зеленой командой» и «красной командой», которые указывают на основной цвет их логотипа.

Среди выдающихся разработчиков GPU - Nvidia и AMD / ATI.

## Происхождение GPU

Самый примитивный фон GPU можно сопоставить с эпохой контроллеров VGA (Virtual Graphics Array). Но на самом деле они не были целым процессором, а выступали в качестве поддерживающих модулей для функций отображения. Контроллер VGA - это простой контроллер памяти, подключенный к Dynamic RAM и генератору дисплея. Основная функция VGA - получать данные изображения, правильно распределять их и отправлять на видеоустройство, которое в основном представляет собой монитор компьютера или экран телевизора, подключенный к игровой консоли для отображения.

Первый полнофункциональный процессор для графического ускорения был разработан и продан NVIDIA в 1999 году «GeForce 256». Старые 3D-ускорители должны были полагаться на CPU для выполнения графических расчетов. Благодаря новой «GeForce 256» в качестве сопроцессора для процессора, улучшенной частоте кадров более чем на 50% и снижению общей стоимости, тем самым расширяя себя на потребительском рынке.

## Графический процессор и процессор

ЦП оптимизирован для минимальной задержки, т. Е. «Иметь возможность выполнять как можно больше инструкций, принадлежащих одному серийному потоку, в заданное время». Процессор должен иметь возможность быстро переключаться между операциями. Чтобы получить большую задержку в ЦП, в процессоре много инфраструктуры, например, большие кеши, которые могут быть легко доступны для выполнения, множество блоков управления для выполнения вне очереди и несколько ядер ALU. ISA CPU спроектирован более обобщенным образом и может выполнять широкий спектр операций. Хотя процессор был разработан для вычислений и инструкций общего назначения, графический процессор был разработан для графических вычислений. То же вычисление должно выполняться на сотнях и тысячах пикселей для 2D / 3D-рендеринга графики. Таким образом, графические процессоры были в основном оптимизированы для максимальной пропускной способности. Это реализовано с использованием тонны ALU в единой архитектуре. Кэш L2 сокращается, поскольку до тех пор, пока данные не будут извлечены из DRAM, ядра GPU будут иметь множество вычислений для выполнения, тем самым перекрывая время ожидания CPU с массивным параллелизмом. Это называется скрытым скрытием.

## Эволюция архитектуры графического процессора

Графические процессоры первоначально были смоделированы по концепции графического конвейера. Графический конвейер является теоретической моделью, состоящей из уровней, по которым графические данные должны быть отправлены и выполнены с использованием графического процессора и программного обеспечения (например, OpenGL, DirectX). Конвейер в основном преобразует трехмерные пространственные координаты в 2D пикселированные данные для отображения устройства. Ниже приведена иллюстрация «Традиционный графический конвейер с фиксированной функцией», общепринятый трубопровод до сегодняшнего дня.

### 0-е поколение

Плата «Reality Engine» от Silicon Graphics Inc. (SGI) ознаменовала начало аппаратного обеспечения графического процессора и графического конвейера. Но технология все еще зависела от процессора в первом тайме. Кроме того, скорость была ограничена одним исполнением пикселя за такт. Двигатель использует OpenGL, широко используемое 2D / 3D-приложение.
<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/0/09/SGI-re2-ge10v.jpg/220px-SGI-re2-ge10v.jpg" alt="Reality Engine" title="Reality Engine">

### 1stGeneration

«3dfx Voodoo» (1996) превратился в один из первых настоящих 3D-ускорителей для игр. Он обрабатывал отображение текстур, растеризацию и z-буферизацию, но ЦП все еще должен был делать вершинные преобразования.
<img src="https://tferi.hu/cikkek/videocard13.jpg" alt="Vodoo" title="3dfx Voodoo">

### 2ndGeneration

Это тот момент, когда первый в истории настоящий графический процессор NVIDIA «GeForce 256» был выпущен на общем рынке. Графические процессоры используемого ускорительного графического порта (AGP) этого поколения предложили новые функции, такие как мультитекстурирование, преобразование геометрии оборудования, карты света и освещение. Традиционные трубопроводы назывались конвейером «фиксированной функции», поскольку после того, как разработчик отправил графические данные в конвейер графического процессора, данные не могли быть изменены.
img src="https://cdn.videocardz.net/cache/18200040c7e7e8ed83b18878d3ae0cb7-1200x900.jpg" alt="GeForce256" title="GeForce256">

### Третье поколение

С этим поколением процессоров появилась программируемая конвейерная обработка. Теперь программисты могут запрограммировать ранее не программируемые части. В 2001 году NVIDIA выпустила GeForce3.
<img src="https://prohardver.hu/dl/cnt/2003-08/253/cards/ti200.jpg" alt="3 Ti200" title="GeForce3 Ti200">

### 4-е поколение

С начала XXI века первые «полностью программируемые графические карты» достигли потребителей. Среди первых среди них были NVIDIA GeForce FX, ATI Radeon 9700. Эти графические процессоры могут выполнять операции с пикселями, а также пиксельные шейдеры и программируемые вершины. Но для обработки шейдеров вершин и обработки пиксельных шейдеров необходимы отдельные специализированные аппаратные средства.
<img src="http://vgamuseum.info/images/zaatharen/ati/Radeon9700_fhq.jpg" alt="9700" title="ATI Radeon 9700">


### Пятое поколение

Графические процессоры развивались и продвигались на пиковой скорости, и графические процессоры этого поколения были первыми, кто использовал шину PCI-Express. Были добавлены несколько буферов рендеринга, поддержка 64-бит, доступ к текстуре и т. Д., А также увеличение объема памяти GPU.
<img src="https://images.pcworld.com/news/graphics/117070-2209P058_1B.jpg" alt="Geforce and Ati" title="ATI Radeon X600 XT and Nvidia 6800 GT">

### 6-е поколение

В 2006 году выпуск графического процессора NVIDIA GeForce 8 произвел революцию в индустрии графических процессоров и стал доступен благодаря внедрению GPU в виде массивно-параллельных процессоров. Он был первым, у которого были «унифицированные» и «программируемые» шейдеры или, другими словами, программируемый унифицированный процессор. Унифицированный означает, что все процессы графического конвейера выполнялись на одном процессоре, и для любой стадии внешний блок не требуется. Основные компоненты архитектуры унифицированного графического процессора обсуждаются ниже.

Начиная с выпуска графических процессоров NVidia серии 9XX, увеличение производительности между поколениями только улучшилось. От 980Ti до 1080Ti и недавно запущенных 208Tis производительность более чем удвоилась. AMD также начала выпускать лучшие графические процессоры, такие как RX 580 и Vega 64, хотя это все еще не приближается к уровню Nvidia. Совсем недавно Nvidia запустила новую линейку графических процессоров под названием RTX, которая включает в себя карты более высокого класса, такие как 2080Ti, 2080 и 2070. RTX означает «Трассировка лучей», которая является техникой рендеринга, используемой для генерации изображений, хотя и отслеживает путь света в сцене.
<img src="https://prod.scorptec.com.au/35/461/74299/163470_large.jpg" alt="RTX 2080Ti" title="Asus RTX1080 Ti">

## Компоненты базовой архитектуры единой архитектуры GPU

Унифицированные архитектуры GPU основаны на параллельном массиве многих программируемых процессоров, в котором все этапы графического конвейера, а именно: вершина, геометрия, растеризация и обработка пиксельных шейдеров и параллельные вычисления на одном и том же ядре, в отличие от предыдущих графических процессоров. Массив процессора очень интегрирован с фиксированными функциональными процессорами для сжатия и декомпрессии, растеризации, растровых операций, фильтрации текстур, сглаживания, декодирования видео и обработки видео высокой четкости.

Следующая обсуждаемая архитектура ориентирована на эффективное выполнение множества параллельных потоков на многих процессорных ядрах.

### Массив процессора

Массив процессора состоит из многих процессорных ядер. Единый процессорный процессор GPU имеет типичную организованную структуру многопоточных мультипроцессоров. Для выполнения каждого потока задействован многопроцессор, и в каждом многопроцессорном процессоре GPU, также известном как потоковые мультипроцессоры (SM), существует множество потоковых процессоров, расположенных в очереди. Все процессоры подключаются к разделам DRAM через сеть межсетевого соединения.

### Многопоточность

Как обсуждалось ранее, GPU оптимизирован для обеспечения высокой пропускной способности и скрытия времени ожидания. Высокопроизводительная многопоточность уменьшает задержку загрузки памяти из DRAM. Хотя поток находится в режиме ожидания из-за завершения загрузки или команды выбора, процессор может выполнить другой поток. Кроме того, из-за высокой степени многопоточности графический процессор поддерживает мелкозернистые модели параллельного графического шейдерного программирования и мелкомасштабные параллельные модели компьютерного программирования.

### Многопроцессорная архитектура

Помимо нескольких процессорных ядер в SM, существуют специальные функциональные блоки, многопоточный блок команд, инструкции и постоянные кеши и общая память. Кроме того, каждое ядро ​​состоит из большого многопоточного регистрационного файла (RF). Каждое потоковое ядро ​​процессора состоит из целых и арифметических единиц с плавающей запятой, которые вместе могут обрабатывать большую часть операций.

### SIMT

В потоковом многопроцессорном процессоре используется архитектура с однопоточным многопоточным (SIMT). Инструкции выполняются в группе параллельных потоков, известных как деформации. Каждый параллельный поток имеет тот же тип и запускается вместе с одним и тем же адресом программы. Архитектура процессора SIMT очень похожа на архитектуру SIMD. В SIMT определенная команда выполняется в нескольких параллельных потоках независимо, в то время как в SIMD одна и та же команда выполняется на нескольких полосах данных в синхронных группах.

### Потоковый процессор

Он выполняет все основные операции FP, а также арифметику, сравнение, преобразование и логические инструкции PTX. Специальный функциональный блок Некоторые из инструкций потока выполняются на SFU одновременно с другой инструкцией потока, выполняемой на SP.

#### Дополнительная информация:

*   [Википедия](https://en.wikipedia.org/wiki/Graphics_processing_unit)
*   [OpenACC](https://www.openacc.org/)
*   [CUDA](https://developer.nvidia.com/cuda-zone)
*   [OpenCL](https://www.khronos.org/opencl/)
*   [OpenGL](https://www.opengl.org/)
*   [Блог nVidia](https://blogs.nvidia.com/blog/2009/12/16/whats-the-difference-between-a-cpu-and-a-gpu/)
*   [NVidia](https://www.nvidia.com/)
*   [AMD](http://www.amd.com/en-us/products/graphics)
