---
title: Storage Drives
localeTitle: Диски хранения
---
## Жесткие диски (HDD)

Жесткие диски являются постоянными устройствами хранения для компьютеров. Существует несколько типов жестких дисков: традиционные магнитные диски, твердотельные диски нового поколения или гибридные диски, которые содержат как SSD, так и магнитную память.

Традиционные жесткие диски используют магнитные иглы и вращающиеся намагниченные пластины для хранения данных. Благодаря этим движущимся частям жесткие диски легко повреждаются капли и / или удары. Двигатель, который вращает плиты, также потребляет много энергии, и все же никакой другой способ хранения не является столь доступным для больших объемов хранения.

Жесткие диски поставляются в различных емкостях хранения, а некоторые даже хранят 10 ТБ (10 триллионов байтов). Типичные компьютеры поставляются с 256 ГБ (256 миллионов байт) до 1 ТБ дискового пространства. Ноутбуки обычно используют твердотельные диски (SSD), потому что они быстрее, легче и не содержат движущихся частей, что делает их менее вероятными из-за воздействия. Для такого же объема хранения SSD обычно дороже, чем жесткие диски. В последнее время некоторые SSD были выпущены с интерфейсом с материнской платой через слот PCIe (PCI Express) с использованием системы под названием NVMe. Эти SSD оказались еще быстрее в режиме чтения / записи по сравнению с традиционными SSD-накопителями SATA.

Магнитные головки отвечают за считывание и запись данных, которые физически хранятся на множестве дисков с магнитным покрытием, уложенных друг над другом, называемых пластинами. Головки расположены в конце арматуры. Внутренние диски пластинки имеют две головки на одной руке. Это позволяет получить доступ к данным с обоих дисков, ниже и выше рычага. У верхнего и нижнего дисков пластинки есть только одна голова в конце руки. На противоположном конце рычага находится привод. Он обеспечивает перемещение руки для перемещения из центра тарелки, шпинделя, в крайние области пластины. Время, необходимое для размещения головы в правильном концентрическом местоположении, называется временем поиска. Когда головка находится в правильном концентрическом пространственном местоположении, больше времени тратится на ожидание вращения диска, так что сектор с запрошенными данными находится под головкой. Это время называется латентностью.

Головки расположены всего в нескольких нанометрах от вращающихся дисков. Говорят, что голова «летает» над блюдом, и поэтому расстояние между головой и пластиной называется «высотой полета». Головки предназначены для того, чтобы никогда не прикасаться к местам пластин, которые хранят данные и имеют магнитное покрытие. Если голова «приземлится» на тарелку, обе головы и секторы пластин могут быть уничтожены, что приведет к потере данных (отсюда и фраза «крушение жесткого диска» или «крушение головы»).

Жесткие диски извлекают и сохраняют данные из приложений по запросу ЦП. Это называется операциями ввода-вывода - короткое замыкание. Когда работающая программа требует определенной части данных, CPU отправляет инструкцию для данных, которые будут извлекаться с жесткого диска. Чтение этой части данных - операция ввода (с точки зрения ЦП). Затем программа может выполнить вычисление, которое изменяет данные, и результаты должны быть сохранены обратно на жесткий диск. Процессор запрашивает, чтобы данные были записаны обратно на диск. Это будет пример операции вывода (опять же, с точки зрения ЦП).

Производительность жесткого диска измеряется в основном двумя ключевыми метриками: 1) временем отклика, которое является длительностью выполнения операции чтения или записи, и 2) IOPS, которая является аббревиатурой «Операции ввода / вывода в секунду». Как следует из названия, IOPS представляет собой измерение максимальных операций ввода-вывода за одну секунду. Основным фактором достижения максимального IOPS при наименьшем времени отклика является скорость вращения жесткого диска, измеренная в оборотах в минуту (об / мин). Общие частоты вращения составляют 5400 об / мин, 7,200 об / мин, 10 000 об / мин и 15 000 об / мин (обычно обозначаются как 5,4K, 7,2K, 10K и 15K). Жесткие диски с более высокими скоростями вращения RPM) будут иметь больше пропускной способности недвижимости под головками для операций ввода-вывода (чтение и запись). Жесткие диски с более низким коэффициентом вращения RPM будут иметь гораздо более высокие механические задержки, так как меньше предметов недвижимости проходит под головами.

Один простой инструмент для измерения показателей производительности жестких дисков называется IOMeter (см. Ссылку ниже). Программа очень легкая и простая в установке. После его запуска и запуска может быть запущено несколько различных вариантов рабочих нагрузок для имитации чтения и записи данных на диск. Эти данные анализируются и выводят показатели для времени чтения / записи, IOPS, а также другие полезные показатели. Тесты могут быть сохранены для согласованных проверок, и данные могут быть легко проанализированы в виде таблицы или графика.

Жесткие диски, как правило, классифицируются по варианту использования (емкость или производительность). Домашние ПК и общие офисные рабочие места обычно используют более медленные вращающиеся жесткие диски (5.4K и 7.2K), которые отлично подходят для хранения изображений и офисных файлов. Однако, например, крупные базы данных, которые поддерживают транзакции онлайн-банкинга, используют более быстрые жесткие диски 10K и 15K RPM, поскольку они будут компонентами на корпоративном сервере или массиве хранения. Однако есть компромисс между производительностью и емкостью жесткого диска. Например, самый большой жесткий диск емкостью 15 КБ, доступный сегодня, составляет всего 600 ГБ, тогда как самый большой жесткий диск с максимальной емкостью 5,4 тыс. И 7,2 тыс. RPM составляет 10 ТБ. Привод 600 ГБ на 15 Кбит / с способен на 250 мкс времени отклика 3 мс (среднее значение). В то время как 10-Тбайт 7,2 КБ-накопитель не измеряет IOPS в заданное время отклика, так как он не оптимизирован и не предназначен для использования в IOPS. Есть также другие компромиссы в цене за ГБ, потребляемая энергия и размер (2,5 "против 3,5 дюйма).

Компьютеры хранят данные и файлы на жестких дисках для последующего использования. Поскольку на жестких дисках есть движущиеся части, для чтения файла с жесткого диска требуется гораздо больше времени, чем из ОЗУ или кэш-памяти на CPU. Вы можете думать о жестком диске в качестве шкафа для хранения: место для хранения вещей, которые мы сейчас не используем, но нужно позже. У вас недостаточно места на столе для всех ваших бумаг, поэтому вы храните вещи, которые не используете сейчас, в шкафу для подачи документов. Компьютер делает именно это. Он хранит файлы, которые он использует прямо сейчас в ОЗУ, и файлы, которые могут потребоваться позже, остаются на жестком диске. Хотя операционная система имеет время доступа и ответа, которые на два порядка быстрее по сравнению с жесткими дисками, их типичная емкость на 1-2 порядка меньше, чем обычный жесткий диск. Вы можете вставлять бумагу в картотеку, но только несколько на вашем столе.

Данные, хранящиеся в ОЗУ, считаются мимолетными, тогда как данные, записанные на жесткий диск, являются постоянными. Если мощность внезапно погаснет, все данные, находящиеся в ОЗУ, будут потеряны и не будут присутствовать после восстановления питания и перезагрузки компьютера. Однако данные, записанные на жесткий диск, будут там, когда питание будет восстановлено. По этой причине современные операционные системы и приложения будут периодически записывать данные сеанса и приложения, находящиеся в настоящее время в RAM, на жесткий диск. Таким образом, если питание отключится, всего 10 минут данных, введенных во вновь созданную электронную таблицу, которая работала в течение 3 часов, предшествующих отключению питания, и еще не сохранена на жестком диске. Эти файлы обычно обозначаются тильдой ~ и могут быть найдены во временном или временном каталоге или, возможно, в «слепом каталоге», содержимое которого называется скрытыми файлами.

## Твердотельные диски (SSD)

Твердотельные диски используют интегральные схемы для хранения данных. Поэтому SSD не имеет движущихся частей, таких как HDD. Это делает их менее подверженными физическим ударам, работает бесшумно и имеет более быстрое время чтения / записи, не требуя физического поиска данных.

SSD обычно используются только как загрузочные диски или хранилища для большинства используемых приложений на компьютере пользователя. Это связано с тем, что, хотя в последние годы его цена значительно уменьшилась, она по-прежнему намного дороже, чем традиционный жесткий диск. Таким образом, жесткие диски по-прежнему используются для хранения больших фрагментов данных, таких как наши фотографии и видео, или в центрах обработки данных или серверных фермах.

#### Дополнительная информация:

*   [Википедия - жесткий диск](https://en.wikipedia.org/wiki/Hard_disk_drive)
*   [Википедия - Высота полета](https://en.wikipedia.org/wiki/Flying_height)
*   [Википедия - Хранение компьютерных данных](https://en.wikipedia.org/wiki/Computer_data_storage)
*   [PCMag - SSD против HDD: какая разница?](https://www.pcmag.com/article2/0,2817,2404258,00.asp)
*   [Цифровые тенденции - SSD и HDD](https://www.digitaltrends.com/computing/solid-state-drives-vs-hard-disk-drives)
*   [Проект IOMeter](http://www.iometer.org)