---
title: Compiled Versus Interpreted Languages
localeTitle: Скомпилированные и интерпретируемые языки
---
## Скомпилированные и интерпретируемые языки

Каждая программа представляет собой набор инструкций, будь то добавить два номера или отправить запрос через Интернет. Компиляторы и интерпретаторы воспринимают читаемый код и преобразуют его в машиночитаемый машинный код. На скомпилированном языке целевая машина напрямую переводит программу. В интерпретируемом языке исходный код непосредственно не переводится на целевую машину. Вместо этого _другая_ программа, так называемый интерпретатор, считывает и выполняет код.

### Хорошо ... но что это на _самом деле_ означает?

Итак, скажем, у вас есть рецепт hummus, который вы хотите сделать, но он находится на древнегреческом языке. Есть два пути, которыми вы, как не-древнегреческий оратор, могли следовать его указаниям.

Во-первых, если кто-то перевел его на английский язык уже для вас. Вы (и любой, кто мог говорить по-английски) могли получить английскую версию и сделать hummus. Это скомпилированная версия.

Во-вторых, если у вас есть друг, который знает Древнегреческий. Ваш друг может сидеть рядом с вами и переводить древнегреческий на английский, по очереди, как вы идете. В этом случае ваш друг является переводчиком. Это интерпретированная версия.

### Скомпилированные языки

Компилированные языки преобразуются непосредственно в машинный код, который может выполнять процессор. В результате они, как правило, работают быстрее и эффективнее, чем интерпретируемые языки. Они также дают разработчику больше контроля над аппаратными аспектами, такими как управление памятью и использование ЦП.

Компилированные языки нуждаются в шаге «build» - их сначала нужно скомпилировать вручную. Вам нужно «перестроить» программу каждый раз, когда вам нужно внести изменения. В нашем примере hummus весь перевод написан до того, как он доберется до вас. Если первоначальный автор решил, что хочет использовать другой вид оливкового масла, весь рецепт нужно будет перевести снова, а затем отправить к вам.

Примерами чистых компилируемых языков являются C, C ++, Erlang, Haskell, Rust и Go.

### Интерпретированные языки

Интерпретаторы будут запускать программу по очереди и выполнять каждую команду. Теперь, если автор решил, что хочет использовать другой вид оливкового масла, он может поцарапать старый и добавить новый. Затем ваш переводчик может передать это изменение вам, как это происходит.

Когда-то, как известно, интерпретируемые языки были значительно медленнее, чем скомпилированные языки. Но с разработкой [компиляции](https://guide.freecodecamp.org/computer-science/just-in-time-compilation) « [точно в срок»](https://guide.freecodecamp.org/computer-science/just-in-time-compilation) этот разрыв сокращается.

Примерами распространенных интерпретируемых языков являются PHP, Ruby, Python и JavaScript.

### Небольшой оговорка

Большинство языков программирования могут иметь как скомпилированные, так и интерпретируемые реализации. Сам язык не обязательно компилируется или интерпретируется. Однако для простоты их обычно называют такими.

Строго говоря, термины, интерпретируемые языком и скомпилированным языком, не определены должным образом, поскольку теоретически любой язык программирования может быть интерпретирован или скомпилирован. В современной реализации на языке программирования все более популярным становится платформа для предоставления обоих вариантов. например, Python может выполняться либо как скомпилированная программа, либо как интерпретируемый язык в интерактивном режиме.

**Большинство инструментов командной строки, CLI и оболочек теоретически могут быть классифицированы как интерпретируемые языки.**

### Преимущества и недостатки

#### Преимущества скомпилированных языков

Программы, скомпилированные в собственный код во время компиляции, обычно имеют тенденцию быть быстрее, чем те, которые были переведены во время выполнения из-за накладных расходов на процесс перевода.

#### Недостатки скомпилированных языков

Наиболее значительными недостатками являются: -

*   Дополнительное время, необходимое для завершения всего этапа компиляции перед тестированием, и
*   Платформенная зависимость генерируемого двоичного кода.

#### Преимущества интерпретируемых языков

Интерпретированный язык предоставляет реализации некоторую дополнительную гибкость по сравнению с компилируемыми реализациями. Поскольку интерпретаторы сами выполняют код исходной программы, сам код является независимым от платформы (например, байтовый код Java). Другие функции включают динамическую типизацию и меньший размер исполняемой программы.

#### Недостатки интерпретируемых языков

Наиболее заметным недостатком является типичная скорость выполнения по сравнению с скомпилированными языками.

#### Дополнительная информация:

[Википедия - Скомпилированный язык](https://en.wikipedia.org/wiki/Compiled_language)

[Википедия - Интерпретированный язык](https://en.wikipedia.org/wiki/Interpreted_language)

[articlemer.com - В чем разница между скомпилированным и интерпретируемым языком?](http://www.programmerinterview.com/index.php/general-miscellaneous/whats-the-difference-between-a-compiled-and-an-interpreted-language/)