---
title: Graphs
localeTitle: диаграммы
---
## диаграммы

График - это структура данных, которую вы можете использовать для решения проблем маршрутизации, таких как «Связаны ли эти два компонента?» и «Каков самый короткий путь от точки a до b?»

Граф состоит из узлов и ребер. Узел (т.е. вершина) является объектом вашего графика. Узел может содержать информацию, такую ​​как имя узла и к каким кромкам он привязан. Кромка - это связь, соединяющая два узла. Край может содержать информацию, такую ​​как вес края. Если два узла соединены ребром, они являются соседями (то есть смежными).

В зависимости от проблемы вы можете использовать двусторонние (неориентированные) или односторонние (направленные) ребра. Если у вас есть неориентированный край от a до b, есть также путь от b до a. Если у вас есть направленное ребро от a до b, не обязательно будет край от b до a.

Графики можно использовать для формулирования таких ситуаций, как:

*   Географические карты
*   Каждый город в вашей стране является узлом
*   Если два города связаны дорогой, между ними есть край \* Дороги могут быть одно- или двухсторонними (как направленными, так и неориентированными краями) \* вес может быть длиной дороги
*   Поток воды
    *   Каждый шлюз является узлом
    *   Каждый канал - это край
        *   вода будет течь только в одном направлении, так что края направлены
        *   вес может быть максимальной водной емкостью потока

Пример: график, который имеет узлы столиц северных стран и как (неориентированные) края, расстояние до городов, связанных прямой дорогой.
```
.     +---------+ 
 .     |Reykjavik| 
 .     +---------+ 
 . 
 . 
 .         529 km   +---------+  1760 km  +--------+ 
 .    +------------+|Stockholm|+---------+|Helsinki| 
 .    |             +---------+           +--------+ 
 .    +                                        + 
 . +----+                    1991 km           | 
 . |Oslo|+-------------------------------------+ 
 . +----+ 
 .         +----------+ 
 .         |Copenhagen| 
 .         +----------+ 
```

#### Дополнительная информация:

[Первый поиск Breadth (BFS)](https://github.com/freecodecamp/guides/tree/master/src/pages/algorithms/graph-algorithms/breadth-first-search/index.md)

[Глубина первого поиска (DFS)](https://github.com/freecodecamp/guides/tree/master/src/pages/algorithms/graph-algorithms/depth-first-search/index.md)