---
title: ACID
localeTitle: ACID
---
## ACID

В области информатики ACID (Atomicity, Consistency, Isolation, Durability) представляет собой набор свойств для модификаций базы данных. Они помогают гарантировать действительность транзакции, даже с ошибками или сбоями.

**Транзакция** представляет собой любую последовательность операций с базой данных, которая удовлетворяет свойствам ACID и может рассматриваться как одна логическая операция над данными. Примером может служить перевод средств с одного банковского счета на другой. Это связано с несколькими изменениями, такими как дебетование одной учетной записи и другое кредитование, но считается одной транзакцией.

### валентность

Это означает, что сложная транзакция либо полностью обрабатывается, либо вообще не обрабатывается. Если одна часть транзакции выходит из строя, вся транзакция не завершается, и база данных не изменяется. Таким образом, если произошел сбой, сбой питания или ошибка, база данных не заканчивается в состоянии, когда выполняются только части транзакции.

### консистенция

Это означает, что данные будут согласованными. Любые данные, введенные в базу данных, должны быть действительными и разрешены на основе любых ограничений, которые вы указали. Он гарантирует, что любая транзакция изменяет базу данных из одного действительного состояния в другое действительное состояние.

### изоляция

Это означает, что если две транзакции выполняются одновременно, одна транзакция не может читать данные из транзакции, которая еще не завершена. Каждая транзакция будет видеть базу данных, как если бы транзакции выполнялись последовательно. Если одной транзакции необходимо прочитать данные, которые другая пишет, она должна дождаться завершения другой транзакции. Последствия неполной транзакции не повлияют на другую транзакцию.

### долговечность

Это означает, что после завершения транзакции он останется таким же, даже в случае потери мощности или других ошибок. Он гарантирует, что все изменения записываются на энергонезависимый носитель данных (например, на жесткий диск), и он записывает завершенную транзакцию.

### Дополнительная информация:

*   Статья ACID: [Википедия](https://en.wikipedia.org/wiki/ACID)
*   Обзор видео: [YouTube](https://www.youtube.com/watch?v=LSB4eceRsw8)