---
title: Key Value Databases
localeTitle: Базы данных ключевых значений
---
## Базы данных ключевых значений

База данных с ключом или хранилище ключей - это тип базы данных [NoSQL, в](https://en.wikipedia.org/wiki/NoSQL) которой используется хранилище ключей / значений. Это означает, что данные, хранящиеся в базе данных, представляют собой набор пар ключ-значение.

Такая структура данных используется на многих языках программирования. Пары ключевых значений обычно называются ассоциативными массивами, словарями или хэшем. Например, рассмотрите словарь телефонных номеров:

| ключ | стоимость | | ------------ | ------------- | | Рик | 1234555 | | Морти | 7754321 | | Лето | 5512377 |

### Ключ

`key` в паре ключ-значение должен быть уникальным. Наличие уникального идентификатора позволит вам получить доступ к значению, связанному с данным ключом.

Теоретически ключ может быть любым, что вы хотите. Ключ может быть строкой, двоичной последовательностью, изображением и другими. Однако некоторые базы данных могут налагать ограничения на тип ключей, которые можно использовать.

Вот несколько рекомендаций:

*   Ключи должны следовать конвенции, чтобы иметь согласованность. Ключи в словаре телефонных номеров всегда должны быть именами, а не комбинацией имен, адресов электронной почты и номеров.
*   Ключи не должны быть слишком длинными, или у вас могут быть проблемы с производительностью.
*   Ключи не должны быть слишком короткими, или у вас могут быть проблемы с читабельностью.

### Значение

`value` в хранилище значений ключей может быть любым, что вы хотите. Сюда входят строки, цифры, код, изображение, список или даже другая пара ключей. Некоторые базы данных позволяют ограничить тип данных, которые можно сохранить.

### Случаи применения

Базы данных с ключом можно использовать для нескольких сценариев. Вот список наиболее распространенных приложений:

*   Телекоммуникационные каталоги.
*   Профили пользователей и информация о сеансе.
*   Содержимое корзины.
*   Сведения о продукте или отзывы.
*   Таблицы пересылки Интернет-протокола (IP).
*   Состояние или конфигурация службы.

### Примеры

Вот несколько примеров баз данных, в которых используется подход «ключ-значение»:

*   [Redis](https://redis.io)
*   [База данных Oracle NoSQL](https://www.oracle.com/database/nosql/index.html)
*   [Cassandra](http://cassandra.apache.org) (гибрид между ключевыми и ориентированными на столбцы базами данных)
*   [Волдеморт](http://www.project-voldemort.com/voldemort/)
*   [Consul KV store](https://www.consul.io/intro/getting-started/kv.html) (инструмент с собственным хранилищем ключей)

#### Дополнительная информация:

*   Базы данных по ключевым словам в [Википедии](https://en.wikipedia.org/wiki/Key-value_database)

База данных Key-Value - простая база данных, которая использует карту или словарь в качестве базовой модели данных, где каждый ключ связан с одним и только одним значением в коллекции и является наиболее гибким типом базы данных NoSQL.