---
title: Non-Relational-Databases
localeTitle: Нереляционную-Базы данных
---
## Когда использовать

Если вы имеете дело с феноменально огромным количеством данных, это может быть слишком утомительным, и вероятность ошибки (в виде ошибки несоответствия ОРМ) возрастает. В этой ситуации вам может потребоваться рассмотреть возможность использования нереляционной базы данных. Нереляционная база данных просто хранит данные без явных и структурированных механизмов для связывания данных из разных таблиц (или кодов) друг с другом. Если ваша модель данных оказывается очень сложной, или если вам приходится де-нормализовать схему базы данных, то не реляционные базы данных могут быть лучшим способом.

Другие причины выбора нереляционной базы данных:

*   Необходимость хранить сериализованные массивы в объектах JSON
*   Хранение записей в той же коллекции, которая имеет разные поля или атрибуты
*   Нахождение себя в нормализации вашей схемы или кодирования базы данных по проблемам производительности и горизонтальной масштабируемости
*   Проблемы легко предопределяют вашу схему из-за характера вашей модели данных

## Недостатки

В нереляционных базах данных не существует объединений, как в реляционных базах данных. Это означает, что вам необходимо выполнить несколько запросов и вручную объединить данные в свой код, и это может стать очень уродливым, очень быстрым.

## Примеры баз данных

*   MongoDB
*   NoSQL

## Рекомендации

*   (Https://www.pluralsight.com/blog/software-development/relational-non-relational-databases)
*   (Https://en.wikipedia.org/wiki/NoSQL)