---
title: Normal Form
localeTitle: Нормальная форма
---
## Нормальная форма

Нормализация была впервые введена как часть реляционной модели. Это процесс организации таблиц данных и столбцов таким образом, который уменьшает избыточность и повышает целостность. Это можно сделать через:

*   Синтез: создает нормализованный дизайн базы данных на основе известного набора зависимостей.
*   декомпозиция: принимает существующий (недостаточно нормированный) проект базы данных и улучшает его на основе известного набора зависимостей

Существуют три обычные нормальные формы (1-й, 2-й и 3-й) плюс довольно продвинутая форма, называемая BCNF. Они прогрессивные: в orther, чтобы претендовать на 3-ей нормальную форму, схема базы данных должна удовлетворять правилам 2-й нормальной формы и т. Д. Для 1-й нормальной формы.

*   **1-я нормальная форма** : информация хранится в таблице, каждый столбец содержит атомные значения, и не повторяются группы столбцов. Это :

1.  Устраняет повторяющиеся группы в отдельных таблицах.
2.  Создает отдельную таблицу для каждого набора связанных данных.
3.  Определяет каждый набор связанных данных с помощью первичного ключа

##### пример

Конструкция, которая нарушает 1-ю нормальную форму, столбец «телефон» не содержит атомных значений

| идентификатор клиента | Имя Фамилия | Телефон | | ------------- | ------------ | ----------- | ---------- ---------------------------- | | 123 | Pooja | Сингх | 555-861-2025, 192-122-1111 | | 789 | Джон | Доу | 555-808-9633 | | 456 | Сан | Чжан | (555) 403-1659 Ext. 53; 182-929-2929 |

Одним из решений было бы иметь дополнительный столбец для каждого номера телефона. Но тогда это будет повторять концептуально тот же атрибут (номер телефона). Более того, добавление дополнительного номера телефона потребует реорганизации таблицы, добавив больше столбца. Это определенно не практично.

Другим решением является наличие отдельной таблицы для клиента ассоциации <-> Телефон: это соответствует 1-й нормальной форме, и по мере необходимости может быть столько строк на одного клиента.

| идентификатор клиента | Имя Фамилия | | ------------- | ------------ | ----------- | | 123 | Pooja | Сингх | | 789 | Джон | Доу | | 456 | Сан | Чжан |

| идентификатор клиента | Телефон | | ------------- | ------------------------ | | 123 | 555-861-2025 | | 123 | 192-122-1111 | | 789 | 555-808-9633 | | 456 | (555) 403-1659 Ext. 53 | | 456 | 182-929-2929 |

*   **2-я нормальная форма** : таблица находится в первой нормальной форме, и все неявные столбцы зависят от первичного ключа таблицы. Это сужает цель таблицы.

##### пример

Дизайн, который нарушает 2-ю нормальную форму. Полное имя модели является первичным ключом, есть другие ключи-кандидаты, такие как {производитель, модель}. Столбец «Страна-производитель» зависит от столбца без ключа (Производитель).

| Производитель | Модель | Полное имя модели | Страна производителя | | --------------------- | -------------- | ------------ ---------- | ---------------------- | | Форте | X-Prime | Forte X-Prime | Италия | | Форте | Ультрачеловек | Forte Ultracan | Италия | | Dent-o-Fresh | EZbrush | Dent-o-Fresh EZbrush | США | | Кобаяси | ST-60 | Кобаяши ST-60 | Япония | | Хох | Зубная мастерская | Hoch Toothmaster | Германия | | Хох | X-Prime | Hoch X-Prime | Германия |

Нормализованный дизайн должен состоять в том, чтобы разбить на две таблицы:

| Производитель | Страна производителя | | --------------------- | ---------------------- | | Форте | Италия | | Dent-o-Fresh | США | | Кобаяси | Япония | | Хох | Германия |

| Производитель | Модель | Полное имя модели | | --------------------- | -------------- | ------------ ---------- | | Форте | X-Prime | Forte X-Prime | | Форте | Ультрачеловек | Forte Ultracan | | Dent-o-Fresh | EZbrush | Dent-o-Fresh EZbrush | | Кобаяси | ST-60 | Кобаяши ST-60 | | Хох | Зубная мастерская | Hoch Toothmaster | | Хох | X-Prime | Hoch X-Prime |

*   **3-я нормальная форма** : таблица находится во второй нормальной форме, и все ее столбцы транзитивно не зависят от первичного ключа. Говорят, что столбец зависит от другого столбца, если он может быть получен из него, например, возраст может быть получен из дня рождения. Транзитивность означает, что эта зависимость может включать другие столбцы. например, если мы рассмотрим три столбца `PersonID BodyMassIndex IsOverweight` , столбец «IsOverweight» транзитивно зависит от «personID» через «BodyMassIndex».

##### пример

Дизайн, который нарушает 3-ей нормальную форму. {Турнир, год} является первичным ключом для таблицы, и из-за этого транзитно зависит столбец «Дата рождения победителя».

| Турнир | Год | Победитель | Победитель Дата рождения | | ---------------------- | ------------- | ------------ ---- | ---------------------- | | Индиана Invitational | 1998 | Аль Фредриксон | 21 июля 1975 года | | Кливленд Open | 1999 | Боб Альберсон | 28 сентября 1968 года | | Де-Мойн Мастерс | 1999 | Аль Фредриксон | 21 июля 1975 года | | Индиана Invitational | 1999 | Чип Мастерсон | 14 марта 1977 |

Дизайн, соответствующий 3-й нормальной форме, будет:

| Турнир | Год | Победитель |  
| ---------------------- | ------------- | ------------ ---- | | Индиана Invitational | 1998 | Аль Фредриксон | | Кливленд Open | 1999 | Боб Альберсон | | Де-Мойн Мастерс | 1999 | Аль Фредриксон | | Индиана Invitational | 1999 | Чип Мастерсон |

| Победитель | Дата рождения | | ---------------- | ------------------- | | Чип Мастерсон | 14 марта 1977 | | Аль Фредриксон | 21 июля 1975 года | | Боб Альберсон | 28 сентября 1968 года |

#### Дополнительная информация:

*   нормализация базы данных по [википедии](https://en.wikipedia.org/wiki/Database_normalization)
*   первая нормальная форма на [википедии](https://en.wikipedia.org/wiki/First_normal_form)
*   вторая нормальная форма на [википедии](https://en.wikipedia.org/wiki/Second_normal_form)
*   третья нормальная форма в [википедии](https://en.wikipedia.org/wiki/Third_normal_form)