---
title: Garbage Collection
localeTitle: Вывоз мусора
---
## Вывоз мусора

#### Что такое сбор мусора?

В общем, неспециалист, сбор мусора (GC) - это не что иное, как сбор или получение памяти, которая была выделена объектам, которые в данный момент не используются в любой части нашей программы. Краткое описание, как показано ниже.

Сбор мусора - это процесс, в котором программы пытаются освободить пространство памяти, которое больше не используется объектами и т. Д. Сбор мусора осуществляется по-разному для каждого языка. На большинстве высокоуровневых языков программирования есть своя сборка мусора. Низкоуровневые языки программирования могут добавлять сборку мусора через библиотеки.

Как было сказано выше, каждый язык программирования имеет свой собственный метод GC. В программировании на C разработчикам необходимо позаботиться о распределении памяти и освобождении, используя функции malloc () и dealloc (). Но в случае разработчиков C # не нужно заботиться о GC, и это также не рекомендуется.

\#### Как происходит распределение памяти? В C # распределение памяти объектов происходит в управляемой куче. который берет на себя CLR (время выполнения общего языка). Распределение памяти для кучи выполняется с помощью win32 dll в ОС, как и в C. Но объекты In C помещаются в память, где свободное пространство соответствует размеру объекта. И отображение памяти является woks на основе концепций Linkedlist. В C # распределение памяти для кучи происходит линейным образом. как один за другим.

Всякий раз, когда создается новый объект. Память выделяется в куче, а указатель перемещается на следующий адрес памяти. Распределение памяти в C # быстрее, чем C. Так как в C памяти необходимо искать и выделять для объекта. так что это займет немного больше времени, чем C #.

\#### Поколения в C # GC? В программировании .net куча имеет три поколения, называемые генерацией 0, 1, 2. Генерация 0 заполняется сначала всякий раз, когда создается новый объект. Сборщик мусора запускается, когда поколение 0 заполняется. вновь созданные объекты помещаются в Generation 0. При выполнении сбора мусора все нежелательные объекты уничтожаются, память освобождается и уплотняется. GC заботится о том, чтобы указывать указатели освобожденной памяти после GC.

Поколения 1 и 2 имеют объект, который имеет более длительный срок службы. GC на поколениях 1 и 2 не будет происходить до тех пор, пока у поколений 0 не будет достаточной памяти для распределения.

Не рекомендуется использовать программный код GC. Хорошо, если это произойдет сам по себе. GC получает вызов, когда заполняется поколение 0. GC не повлияет на производительность вашей программы.

Сбор мусора - это процесс, в котором программы пытаются освободить пространство памяти, которое больше не используется переменными, объектами и т. Д. Сбор мусора осуществляется по-разному для каждого языка. Большинство языков программирования высокого уровня имеют встроенную сборку мусора. Низкоуровневые языки программирования могут добавлять сборку мусора через библиотеки.

Сбор мусора - это инструмент, который экономит время для программиста, например, он заменяет необходимость в таких функциях, как malloc () и free (), которые находятся на C. Это также помогает предотвратить утечку памяти.

Недостатком сборки мусора является то, что это негативно сказывается на производительности. Программа должна регулярно запускаться по программе, проверять ссылки на объекты и очищать память - это требует ресурсов и часто требует приостановки программы.

Если объект не имеет ссылок (больше недоступен), он имеет право на сбор мусора. Например, в приведенном ниже коде Java объект Thing, на который первоначально ссылается «thing1», имеет свою единственную ссылку, перенаправленную на другой объект в куче, - тогда он недоступен и будет иметь память, нераспределенную сборщиком мусора.

```java
class Useless { 
  public static void main (String[] args) { 
  Thing thing1 = new Thing(); 
  Thing thing2 = new Thing(); 
  thing2 = thing1; // direct thing2's reference towards thing1 
                   // no references access thing2 
 } } 
```

Одним из примеров сбора мусора является ARC, сокращенный для автоматического подсчета ссылок. Например, это используется в Swift. ARC сводится к отслеживанию ссылок на все созданные объекты. Если количество ссылок падает до 0, объект будет отмечен для освобождения.

#### Дополнительная информация:

*   https://docs.microsoft.com/en-us/dotnet/standard/garbage-collection/fundamentals - узнать больше о сборке мусора