---
title: Hexadecimal Numbers
localeTitle: Шестнадцатеричные числа
---
## Система шестнадцатеричных чисел

Шестнадцатеричные числа, часто сокращенные до «шестнадцатеричных чисел» или «шестнадцатеричных», представляют собой числа, представленные в базе 16, в отличие от базы 10, которую мы используем для повседневной арифметики и подсчета.

На практике это означает, что каждый столбец числа, записанного в шестнадцатеричном виде, может содержать до 16 значений.

Цифры в шестнадцатеричном порядке используют стандартные символы 0, 1, 2, 3, 4, 5, 6, 7, 8 и 9 для представления соответствующего значения, и использовать первые шесть букв алфавита для представления значений от 10 до 15 (EG: A, B, C, D, E, F).

В программировании мы префикс шестнадцатеричных констант с `0x` , за некоторыми исключениями.

### Примеры и объяснения
```
0x1        ==        1 
 0xF        ==        15 
 0xFF       ==        255 
 0xFFF      ==        4095 
 0x1000     ==        4096 
```

В стандартной системе оснований 10 каждая колонка представляет собой увеличение мощности 10, в то время как в базе 16 каждый столбец представляет возрастающую мощность 16.

Как видно из приведенного выше примера таблицы, с одной шестнадцатеричной цифрой мы можем представлять числа до 15 включительно. Добавьте еще один столбец, и мы можем представить числа до 255, 4095 с другим столбцом и т. Д.

## Использование шестнадцатеричного в низкоуровневом программировании

Шестнадцатеричный сначала нашел свое применение в Computer Science в качестве удобства.

Данные на наших компьютерах имеют самый низкий общий накопитель - Byte. Каждый байт содержит 8 бит и может хранить число от 0 до 255 включительно.

Шестнадцатеричный имеет то преимущество, что он является кратким и имеет четко определенные границы.

Один байт всегда представлен двумя шестнадцатеричными цифрами от 0x00 до 0xFF, причем последний является самым большим байтовым значением 255.

Сопряженные и байт-ориентированные характеры шестнадцатеричных чисел делают их популярным выбором для инженеров-программистов, работающих на низкоуровневых кодовых или встроенных программах.

## Использование шестнадцатеричных чисел в JavaScript

JavaScript поддерживает использование шестнадцатеричной нотации вместо целых чисел, но не десятичных знаков.

В качестве примера число 2514 в шестнадцатеричном формате равно 0x9D2, но нет способа, поддерживающего язык, для представления 25.14 в качестве шестнадцатеричного числа.

Использование шестнадцатеричного кода в вашем коде является личным и стилистическим выбором и не влияет на базовую логику, которую реализует ваш код.

## Использование шестнадцатеричных чисел в CSS

CSS в течение длительного времени использовал шестнадцатеричную нотацию для представления значений цвета. Рассмотрим следующий селектор:

```css
.my-container { 
    background-color: #112233; 
    color: #FFFFFF; 
 } 
```

Значение `background-color` на самом деле представляет собой три шестнадцатеричных байта.

Процессор CSS рассматривает их как три отдельных байта, представляющих красный, зеленый и синий.

В нашем примере 11 соответствует компоненту красного цвета, 22 соответствует компоненту зеленого цвета, а 33 - компоненту синего цвета.

В настоящее время нет способа CSS3 для определения цвета с альфа-компонентом с использованием hex. Предлагаемый проект CSS4 1 включает предложение, позволяющее указать дополнительный байт для указания альфа-значений.

На данный момент использование стандартной функции `rgba()` является рекомендуемым способом добавления альфа-значения в ваши цвета.

#### Дополнительная информация:

*   [Шестнадцатеричная система цифр в Википедии](https://wikipedia.org/wiki/Hexadecimal_numeral_system)
*   [Цвет CSS в веб-документах MDN](https://developer.mozilla.org/en-US/docs/Web/CSS/color)

#### Рекомендации:

*   1 [Цветовой модуль CSS Уровень 4 - 4.2. Шестнадцатеричные обозначения RGB: #RRGGBB](https://www.w3.org/TR/css-color-4/#hex-notation)

#### Дополнительная информация:

*   [Как работают цветовые коды HEX? (через 60 секунд)](https://www.youtube.com/watch?v=c56x1aj2CPA) - Хорошее видео, которое также немного объясняет о шестнадцатеричных числах.
*   [Hex Codes & Color Theory](https://www.youtube.com/watch?v=xlRiLSDdqcY) - более длинное видео, которое вникает в теорию цвета (такие, как аддитивные цвета, а также субтрактивные цвета и т. Д.), А также указывает на другие ресурсы для углубления в тему.
*   [Веб-цвета](https://en.wikipedia.org/wiki/Web_colors) - статья Википедии о том, как цвета используются в Интернете.
*   [Статья в Википедии о шестнадцатеричном коде](https://en.wikipedia.org/wiki/Hexadecimal)
*   [Статья в Википедии о цветах в Интернете](https://en.wikipedia.org/wiki/Web_colors)
*   [Цвета геев](http://www.color-hex.com/)
*   [Средняя статья о шестнадцатеричном цветовом коде](https://medium.com/webkul-dev/hex-color-codes-27cd0a37c3ce)
*   [Дополнительная информация о цветах в CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value)
*   [Исследуйте разные цвета Hex](http://www.colorhexa.com/)