---
title: Asymptotic Notation
localeTitle: Асимптотическое обозначение
---
## Асимптотическое обозначение

Как мы измеряем значение производительности алгоритмов?

Подумайте, как время является одним из наших самых ценных ресурсов. При вычислении мы можем измерить производительность с количеством времени, которое требуется для завершения процесса. Если данные, обработанные двумя алгоритмами, одинаковы, мы можем выбрать наилучшую реализацию для решения проблемы.

Мы делаем это, определяя математические пределы алгоритма. Это большие-О, большие-омега и большая тета, или асимптотические обозначения алгоритма. На графике big-O будет самым длинным алгоритмом для любого заданного набора данных или «верхней границей». Большая-омега похожа на противоположную большую О, «нижнюю границу». Именно здесь алгоритм достигает максимальной скорости для любого набора данных. Большая тета - это либо точное значение производительности алгоритма, либо полезный диапазон между узкими верхними и нижними границами.

Некоторые примеры:

*   «Доставка будет в течение вашей жизни». (big-O, верхняя граница)
*   «Я могу заплатить вам хотя бы один доллар». (большая омега, нижняя граница)
*   «Высокий сегодня будет 25ºC, а низкий - 19ºC». (большой тета, узкий)
*   «Это километровая прогулка до пляжа». (большой тета, точный)

#### Дополнительная информация:

*   [Асимптотическое обозначение](https://learnxinyminutes.com/docs/asymptotic-notation/)