---
title: Big O Notation
localeTitle: Обозначение Big O
---
## Обозначение Big O

_Как компьютерный ученый, если вы работаете над важным программным обеспечением, вам, вероятно, нужно будет оценить, как быстро будет выполняться какой-либо алгоритм или другое._

Обозначение Big O используется в информатике для описания производительности или сложности алгоритма. На самом деле примечание Big O - это специальный символ, который говорит вам, насколько быстро алгоритм. Конечно, вы часто будете использовать предопределенные алгоритмы - и когда вы это делаете, важно понять, насколько они быстры или медленны.

#### Какая надпись Big O выглядит?

![](https://user-images.githubusercontent.com/5860906/31781171-74c6b48a-b500-11e7-9626-f715b37b10f0.png) Это говорит о количестве операций, которые будет делать алгоритм. Это называется записью Big O, потому что вы ставите «Big O» перед количеством операций.  

#### Big O устанавливает наихудшее время выполнения

Скажите, что вы врач, который лечит Гарри Аббита, вы можете заглянуть в электронные записи, связанные с историей болезни Гарри Аббита (он первый человек в списке). Давайте рассмотрим ситуацию, когда его жизнь зависит от всех доступных медицинских данных. Предположим, вы используете простой поиск для поиска человека в электронных записях. Вы знаете, что для простого поиска требуется время O (n), поэтому вам придется просматривать каждую запись для Abbit. Конечно, вы заметили, что Abbit - это первая запись, поэтому вам не нужно было смотреть на каждую запись - вы ее нашли с первой попытки.

_Этот алгоритм взял время O (n)? Или это заняло O (1) раз, потому что вы нашли человека с первой попытки?_

В этом случае это лучший вариант. Но примечание Big O относится к наихудшему сценарию. Это O (n) время (простой поиск по-прежнему занимает). Убедительно, что простой поиск никогда не будет медленнее, чем O (n).

#### Время работы алгоритма растет с разной скоростью

Предположим, для проверки одной записи требуется 1 миллисекунда. При простом поиске врач должен проверить 10 записей, поэтому для поиска требуется 10 мс. С другой стороны, ему нужно проверить только три элемента с _бинарным алгоритмом поиска_ (log10 примерно равно 3), поэтому для поиска требуется 3 мс.

Но реалистично, список будет иметь более ста элементов.

_Если да, то как долго будет проходить простой поиск? Как долго будет бинарный поиск?_

Время прогона для простого поиска с 1 миллиардом предметов составит 1 миллиард мс, что составляет 11 дней. Проблема в том, что время выполнения для двоичного поиска и простого поиска _не растет с одинаковой скоростью_ .

![](https://user-images.githubusercontent.com/5860906/31781165-723a053c-b500-11e7-937c-7b33db281efe.png)

Так как список чисел становится больше, бинарный поиск становится намного быстрее, чем простой поиск. То есть, по мере увеличения количества элементов, бинарный поиск занимает немного больше времени для запуска. Но для простого поиска требуется _намного_ больше времени для запуска. Так как список чисел становится больше, бинарный поиск становится намного быстрее, чем простой поиск.

_Поэтому недостаточно знать, как долго выполняется алгоритм для запуска - вам нужно знать, как увеличивается время работы по мере увеличения размера списка. Вот где появляется запись Big O._

#### Обозначение Big O позволяет сравнить количество операций

Например, предположим, что у вас есть список размеров n. Простой поиск требует проверки каждого элемента, поэтому он будет выполнять n операций. Время выполнения в нотации Big O равно O (n).

_Где секунды?_

Их нет - Big O не говорит вам скорость в секундах. _Обозначение Big O позволяет сравнить количество операций._ Он рассказывает вам, как быстро алгоритм растет.

![](https://user-images.githubusercontent.com/5860906/31781175-768c208e-b500-11e7-9718-e632d1391e2d.png) </ Р

#### Наиболее частое время работы для алгоритмов

Список наиболее распространенных времен работы для алгоритмов с точки зрения нотации Big O. Вот пять раз, когда вы будете сталкиваться с большим количеством событий, которые сортируются от самых быстрых до самых медленных:

1.  O (log n), также известное как _время регистрации_ . Пример: двоичный поиск.
2.  O (n), также известное как _линейное время_ . Пример: простой поиск.
3.  O (n \* log n) Пример: быстрый алгоритм сортировки, такой как quicksort (в главе 4).
4.  O (n 2) Пример: медленный алгоритм сортировки, такой как сортировка сортировки (см. Главу 2).
5.  На!) Пример: очень медленный алгоритм, например, путешествующий продавец (следующий следующий!).

_В этой статье рассматриваются только основные понятия Big O. Для более подробного объяснения взгляните на их соответствующие руководства FreeCodeCamp для алгоритмов._

### Больше информации

*   [Ханская академия](https://www.khanacademy.org/computing/computer-science/algorithms/asymptotic-notation/a/big-o-notation)
*   [Большой чит-лист](http://bigocheatsheet.com/)