---
title: Big Theta Notation
localeTitle: Большая тета-нотация
---
## Большая тета-нотация

Большая Омега сообщает нам нижнюю границу времени выполнения функции, а Big O сообщает верхнюю границу. Часто они отличаются друг от друга, и мы не можем поставить гарантию на время выполнения - это будет варьироваться между двумя границами и входами. Но что происходит, когда они одинаковы? Тогда мы можем дать оценку **тета** (Θ) - наша функция будет работать в это время, независимо от того, какой вклад мы ее даем. В общем, мы всегда хотим, если возможно, дать тета-границу, потому что это самая точная и узкая граница. Если мы не сможем дать привязку тета, следующая лучшая вещь - это самая узкая O-граница.

Возьмем, например, функцию, которая ищет массив для значения 0:

```python
def containsZero(arr): #assume normal array of length n with no edge cases 
  for num x in arr: 
    if x == 0: 
       return true 
  return false 
```

1.  Какой лучший случай? Ну, если массив, который мы даем, имеет 0 в качестве первого значения, он будет занимать постоянное время: Ω (1)
2.  В худшем случае? Если массив не содержит 0, мы будем итерации по всему массиву: O (n)

Мы дали ему омегу и О, а как насчет тета? Мы не можем дать его! В зависимости от массива, который мы даем, время выполнения будет находиться где-то между постоянным и линейным.

Давайте немного изменим наш код.

```python
def printNums(arr): #assume normal array of length n with no edge cases 
  for num x in arr: 
    print(x) 
```

Можете ли вы подумать о лучшем случае и худшем случае? Я не могу! Независимо от того, какой массив мы его даем, мы должны проходить через каждое значение в массиве. Таким образом, функция будет принимать наименьшее время (Ω (n)), но мы также знаем, что это не займет больше времени n (O (n)). Что это значит? Наша функция займет **ровно** n раз: Θ (n).

Если границы сбивают с толку, подумайте об этом так. У нас есть 2 числа, x и y. Нам дано, что x <= y и y <= x. Если x меньше или равно y, а y меньше или равно x, то x должно быть равно y!

Если вы знакомы со связанными списками, проверьте себя и подумайте о времени выполнения каждой из этих функций!

1.  получить
2.  Удалить
3.  Добавить

Все становится еще интереснее, когда вы рассматриваете двойной список!

#### Дополнительная информация:

https://www.khanacademy.org/computing/computer-science/algorithms/asymptotic-notation/a/big-big-theta-notation https://stackoverflow.com/questions/10376740/what-exactly-does-big-%D3%A8-notation-represent https://www.geeksforgeeks.org/analysis-of-algorithms-set-3asymptotic-notations/