---
title: Np Completeness
localeTitle: Полнота Np
---
## Полнота Np

NP-Complete - это свойство определенных типов проблем. Если проблема NP-Complete, это означает, что нет эффективного (полиномиального) алгоритма для быстрого поиска решения. Однако, если нам дано решение, мы можем быстро (в полиномиальное время) убедиться, что оно правильно.

Чтобы быть более конкретным, рассмотрим известную проблему NP-Complete - проблему суммы подмножества. Скажем, мы имеем набор целых чисел {-7, -3, -2, 5, 8}. Мы хотим найти подмножество этих целых чисел, чьи элементы суммируются до 0. Как мы можем это сделать?

Одним из способов было бы просто перечислить все возможные подмножества и проверить, суммируются ли их элементы до 0. Это будет экспоненциально сложным.

И действительно, нет лучшего известного алгоритма, который улучшает экспоненциальную временную привязку. Вот почему он классифицируется как проблема NP-Complete.

Существует множество таких известных проблем, кроме задачи суммирования подмножеств, которые, как известно, являются NP-Complete. Если найден эффективный алгоритм для одного, это означает, что мы можем разработать эффективный алгоритм для всех задач, которые NP-Complete.

Если у вас есть проблема, которая может быть доказана как NP-полная, вы должны прекратить пытаться найти для нее более эффективные алгоритмы и вместо этого использовать эвристику для решения проблемы для большинства тестовых случаев или решить приблизительную версию проблемы. Или, может быть, рассмотрите проблему, которую вы решаете, чтобы убедиться, что она не может быть упрощена к чему-то, что не является NP-Complete.

#### Дополнительная информация:

https://www.ics.uci.edu/~eppstein/161/960312.html https://stackoverflow.com/questions/210829/what-is-an-np-complete-in-computer-science