---
title: Quantum Computing
localeTitle: Квантовые вычисления
---
## Квантовые вычисления

Квантовые вычисления изучают вычислительные системы (квантовые компьютеры), которые непосредственно используют квантовомеханические явления, такие как суперпозиция и запутывание, для выполнения операций с данными.

### Что такое квантовые вычисления?

Природа - в том числе молекулы, такие как кофеин - следует законам квантовой механики, ветви физики, которая исследует, как физический мир работает на самых фундаментальных уровнях. На этом уровне частицы ведут себя странным образом, одновременно принимая более одного состояния и взаимодействуя с другими очень удаленными частицами. Квантовые вычисления используют эти квантовые явления для обработки информации новым и многообещающим способом.

Quantum Computing - это исследование квантовых вычислительных систем, которые используют квантовомеханические явления, такие как запутывание и суперпозиция. Классические цифровые цифровые электронные компьютеры (например, ваш собственный компьютер!) Основаны на транзисторах, которые хранят данные в двоичных разрядах (бит), каждый из которых может находиться в одном из двух состояний (0 или 1). С другой стороны, квантовые компьютеры хранят данные в квантовых битах, которые могут быть в суперпозициях состояний.

Поскольку квантовый компьютер способен воспользоваться этими квантовомеханическими свойствами, теоретически предполагается, что крупномасштабные квантовые компьютеры смогут решить некоторые проблемы намного быстрее, чем классический компьютер.

### Что такое классические компьютеры?

Компьютеры, которые мы используем сегодня, известны как классические компьютеры. Они были движущей силой в мире на протяжении десятилетий - продвигая все от здравоохранения до того, как мы делаем покупки. Но есть определенные проблемы, которые классические компьютеры просто никогда не смогут решить. Рассмотрим молекулу кофеина в чашке кофе. Удивительно, но это достаточно сложно, что ни один компьютер, который существует или не может быть построен, способен моделировать кофеин и полностью понимать его подробную структуру и свойства. Это тот тип кванта задачи, который имеет потенциал для решения.

### Как работают квантовые компьютеры?

Классические компьютеры кодируют информацию в битах. Каждый бит может принимать значение 1 или 0. Эти 1 и 0 действуют как переключатели вкл. / Выкл., Которые в конечном счете управляют функциями компьютера. Квантовые компьютеры, с другой стороны, основаны на кубитах, которые действуют по двум ключевым принципам квантовой физики: суперпозиция и запутывание. Суперпозиция означает, что каждый кубит может одновременно представлять как 1, так и 0. Запутывание означает, что кубиты в суперпозиции могут быть соотнесены друг с другом; то есть состояние одного (независимо от того, является ли оно 1 или 0), может зависеть от состояния другого. Используя эти два принципа, кубиты могут действовать как более сложные коммутаторы, позволяя квантовым компьютерам функционировать таким образом, чтобы они могли решать сложные проблемы, которые невозможно решить с помощью современных компьютеров.

### Что могут делать квантовые компьютеры?

Квантовые системы могут распутать сложность молекулярных и химических взаимодействий, ведущих к открытию новых лекарств и материалов. Они могут обеспечить сверхэффективную логистику и цепочки поставок, такие как оптимизация операций флота для поставок во время курортного сезона. Они могут помочь нам найти новые способы моделирования финансовых данных и изолировать ключевые глобальные факторы риска для улучшения инвестиций. И они могут сделать аспекты искусственного интеллекта, такие как машинное обучение, гораздо более мощным.

### Дополнительные ресурсы

[Квантовые компьютеры объяснены - ограничения человеческих технологий | Kurzgesagt - в двух словах](https://www.youtube.com/watch?v=JhHMJCUmq28)

[Квантовые вычисления объясняются колодой карт | Дарио Гил, IBM Research](https://www.youtube.com/watch?v=yy6TV9Dntlw)