---
title: Qubits
localeTitle: Кубиты
---
## Кубиты

Qubit является коротким для квантового бита, аналогичного бинарной цифре классического компьютера (бит). Это базовая единица информации в квантовом компьютере, точно так же, как двоичная цифра (0 или 1) является базовой единицей информации на классических компьютерах, широко используемых сегодня.

Основное различие между классическим битом и квантовым битом связано с количеством **состояний, в которых** они могут существовать в то время, которое непосредственно влияет на объем информации, которую они могут удерживать. В классической системе бит должен быть в одном состоянии (0) или другом (1) в любой момент времени. Однако **квантовая механика** позволяет кубиту вести себя так, как если бы он находился в обоих состояниях одновременно. Другими словами, каждый используемый дополнительный кубит увеличивает экспоненциально объем информации, которую квантовый компьютер может обрабатывать или удерживать. Это свойство имеет фундаментальное значение для квантовых вычислений.

Чтобы проиллюстрировать это далее, если у вас был один кубит, вы можете одновременно хранить «0» и «1» (что соответствует в общей сложности 2 состояниям или значениям). Если у вас есть 2-кубитная система, вы можете одновременно удерживать **четыре** значения - 00, 01, 10 и 11. С 3-кубитной системой вы можете одновременно удерживать **восемь** значений - 000, 001, 010, 011, 100 , 101, 110 и 111. В общем случае квантовая система, состоящая из n-кубитов, может иметь 2 ^ n-состояния, которые экспоненциально более мощны, чем любой классический компьютер.

#### Дополнительная информация:

[Ars Technica - Объяснение квантовых вычислений и Qubits](https://arstechnica.com/science/2010/01/a-tale-of-two-qubits-how-quantum-computers-work)

[Википедия - Кубит](https://en.wikipedia.org/wiki/Qubit)

[Википедия - Квантовая суперпозиция](https://en.wikipedia.org/wiki/Quantum_superposition)

[Квантовая механика в Википедии](https://en.wikipedia.org/wiki/Quantum_mechanics)