---
title: Shortest Path on a Graph
localeTitle: Самый короткий путь на графике
---
## Самый короткий путь на графике

Поиск кратчайшего пути между двумя точками на графике является общей проблемой в структурах данных, особенно при работе с оптимизацией. Граф - это серия узлов, связанных ребрами. Графики могут быть взвешены (значения, несущие края) и направленные (края имеют направление).

Некоторые применения этого - оптимизация траектории полета или [6 градусов Кевина Бэкона](https://en.wikipedia.org/wiki/Six_Degrees_of_Kevin_Bacon)

## Алгоритм Дейкстры

Наиболее распространенным решением этой проблемы является алгоритм Дейкстры, который обновляет кратчайший путь между текущим узлом и всеми его соседями. После обновления расстояния всех соседей он перемещается к узлу с наименьшим расстоянием и повторяет этот процесс со всеми невидимыми соседями. Этот процесс продолжается до тех пор, пока не будет посещен весь график.

![Изображение уровней кода](https://upload.wikimedia.org/wikipedia/commons/5/57/Dijkstra_Animation.gif)

**Шаг 0:**

Наш график необходимо настроить так, чтобы мы могли записать требуемые значения. На любом ребре мы имеем расстояние между двумя соединяемыми узлами. На любом узле мы имеем кратчайшее расстояние от исходного узла. Позволяет установить значение на каждом узле на положительную бесконечность и установить значение в стартовом узле равным нулю.

**Шаг 1:**

Посмотрите на все узлы, непосредственно связанные с исходным узлом. Значения, передаваемые краями, соединяющими начало и эти смежные узлы, являются кратчайшими расстояниями до каждого соответствующего узла. Запишите эти расстояния на узле - переписывая бесконечность - а также перечеркните узлы, что означает, что их кратчайший путь найден.

**Шаг 2:**

Выберите один из узлов, у которого был рассчитан самый короткий путь, и мы будем называть это нашим стержнем. Посмотрите на узлы, смежные с ним (мы будем называть эти наши узлы назначения) и расстояния, разделяющие их. Для каждого узла назначения: если значение в своде плюс значение грани, соединяющее его, составляет меньше значения целевого узла, а затем обновляет его значение, поскольку новый более короткий путь найден. Если были исследованы все маршруты к этому узлу назначения, его можно скрыть.

**Шаг 3:**

Повторите шаг 2 до тех пор, пока все узлы не будут вычеркнуты. Теперь у нас есть график, где значения, удерживаемые в любом узле, будут кратчайшим для него с узла запуска.

#### Дополнительная информация:

[Подробнее О алгоритме Дейкстры](https://en.wikipedia.org/wiki/Dijkstra%27s_algorithm)

[Другие алгоритмы кратчайшего пути](https://en.wikipedia.org/wiki/Shortest_path_problem#Algorithms)