---
title: What is an API
localeTitle: Что такое API
---
## Что такое API?

API - это интерфейс прикладного программирования. API-интерфейсы скрывают сложность от разработчиков, расширяют системы до партнеров, организуют код и делают компоненты многократными. Не беспокойтесь о AP, просто сосредоточьтесь на I. API - это интерфейс. Вы используете интерфейсы все время. Компьютерная операционная система - это интерфейс. Кнопки в лифте - это интерфейс. Педаль газа в автомобиле - это интерфейс.

Интерфейс находится поверх сложной системы и упрощает определенные задачи, посредника, который избавляет вас от необходимости знать все детали того, что происходит под капотом. Веб-API - это то же самое. Он находится поверх веб-службы, такой как Twitter или YouTube, и упрощает определенные задачи для вас. Он переводит ваши действия в технические детали для компьютерной системы на другом конце.

Если вы когда-либо программировали на объектно-ориентированном языке, таком как Java или C ++, API очень похож на концепцию класса. Когда мы вызываем метод на объект (например, `.toString()` ), нам все равно, КАК объект производит результат, все, о чем мы заботимся, это строка, которую мы получаем в конце. Вызов API работает одинаково. Например, когда мы обращаемся к API Facebook для получения изображения профиля пользователя, нам не важно, как информация извлекается с сервера. Мы просто делаем запрос API, позволяем ему обрабатывать всю сложную логику поиска и получать нашу фотографию в конце всего.

## Почему API полезны?

Доступ к API обычно означает доступ к большому количеству организованных данных. Привратник этих данных дает разрешение разработчика (в форме _ключа API_ ) запрашивать сервер для получения информации. Если запрос выполнен успешно, сервер отвечает сообщением, которое может выглядеть примерно так:

```javascript
{ 
  "coord": { 
    "lon":139, 
    "lat":35 
  }, 
  "wind": { 
    "speed":7.31, 
    "deg":187.002 
  }, 
  "rain": { 
    "3h":0 
  }, 
  "clouds": { 
    "all":92 
  } 
 } 
```

Источник: [Open Weather API](https://openweathermap.org/current)

В приведенном выше примере разработчик запросил текущую погоду на определенной широте и долготе, и сервер ответил _объектом JSON_ о ветре, дождю и облаках для этого местоположения. Службы, которые вы используете каждый день, производятся с помощью тон запросов и циклов реагирования, подобных этому.

**Вот 10 лучших API для начинающих**

1.  Dropbox: https://www.dropbox.com/developers
2.  Карты Google: https://developers.google.com/maps/web/
3.  Twitter: https://dev.twitter.com/docs
4.  YouTube: https://developers.google.com/youtube/v3/getting-started
5.  Soundcloud: http://developers.soundcloud.com/docs/api/guide#playing
6.  Полоса: https://stripe.com/docs/tutorials/checkout
7.  Instagram: http://instagram.com/developer/
8.  Twilio: https://www.twilio.com/docs
9.  Yelp: http://www.yelp.com/developers/getting\_started
10.  Facebook: https://developers.facebook.com/docs/facebook-login/login-flow-for-web

#### Дополнительная информация:

*   [API для не-программистов](https://schoolofdata.org/2013/11/18/web-apis-for-non-programmers/)
*   [Википедия](https://en.wikipedia.org/wiki/Application_programming_interface)
*   [Средняя](https://medium.com/girl-geeks/top-10-apis-for-beginners-4d3c43be9386)