---
title: Clean Code Guidelines
localeTitle: Рекомендации по чистому коду
---
# Рекомендации по чистому коду

При кодировании стиль кодирования, который вы следуете, может быть очень важным. Специально, когда вы работаете с командой или планируете поделиться своим код. Большинство из этих рекомендаций являются стандартными и могут применяться к большинству языков программирования, однако здесь у вас есть приложения и фрагменты с кодом на C ++, поэтому вы можете легко ознакомиться с ним. Помните, что это только рекомендации для достижения ясности, которые могут быть личным преференцией, поэтому возьмите эти советы а не принимать их к письму. Иногда нарушение некоторых из этих правил может привести к созданию более чистого кода.

## Использовать хорошие имена переменных и делать комментарии

Убедитесь, что вы создаете хорошие имена переменных, например, если вы создаете игру, избегайте использования переменной «a», используйте что-то вроде «p1», ссылаясь на игрока 1. [Венгерская нотация](https://en.wikipedia.org/wiki/Hungarian_notation) обычно распространяется и может дать вам некоторые путевые точки для объявления переменные.

Кроме того, ПОЖАЛУЙСТА, используйте комментарии, я даже не шучу, просто попробуйте прочитать некоторые старые проекты, которые вы сделали без комментариев ... теперь представьте, что вы кто-то другой, который даже не закодировал его.

## Глобальные переменные

Глобальные переменные могут быть просты в использовании, и с небольшим кодом он может выглядеть как отличное решение. Но, когда код становится все больше и больше, становится все труднее узнать, когда они используются.

Вместо использования глобальных переменных вы можете использовать переменные, объявленные в функциях, которые могут помочь вам рассказать, какие значения передаются и быстрее выявлять ошибки.

```cpp
#include <iostream> 
 using namespace std; 
 
 // Global variables are declared outside functions 
 int cucumber; // global variable "cucumber" 
```

## Использование goto, продолжить и т. Д.

Это обычное обсуждение среди программистов, как и глобальные переменные, эти типы утверждений обычно считаются плохими. Они считаются плохими, потому что они приводят к [«коду spaguetti»](https://en.wikipedia.org/wiki/Spaghetti_code) . Когда мы программируем, мы хотим линейный поток, при использовании этих утверждений поток изменяется и приводит к «скрученному и запутанному» потоку.

Goto использовался в прошлом, когда, хотя, если функции, однако, были введены в действие для такого структурированного программирования. В общем, избегайте использования goto, если вы не уверены, что сделает ваш код более чистым и более легким для чтения. В качестве примера можно использовать его в вложенных циклах.

Использование разрыва и продолжения практически одинаково. Используйте их в переключателях и пытайтесь выполнять функции с единственной целью, поэтому у вас есть только одна точка выхода.

![IMG](https://imgs.xkcd.com/comics/goto.png)

## Избегайте изменения управляющей переменной внутри цикла for

Обычно есть работы вокруг этого, которые выглядят яснее и менее запутанными, например. в то время как циклы. Делать:

```cpp
int i=1; 
 while (i <= 5) 
 { 
    if (i == 2) 
        i = 4; 
 
    ++i; 
 } 
```

Вместо:

```cpp
for (int i = 1; i <= 5; i++) 
 { 
    if (i == 2) 
    { 
       i = 4; 
    } 
    // Do work 
 } 
```

## Объявлять константы и типы вверху

Они обычно объявляются после библиотек, что делает их доступными и более удобными для чтения. Для локальных переменных это происходит одинаково, объявляйте их наверху (другие люди предпочитают объявлять их как можно более поздними, чтобы сохранить память: [cplusplus.com](http://www.cplusplus.com/forum/general/33612/)

## Используйте только одну функцию возврата в конце

Как мы уже говорили, мы делаем только одну запись и выход, чтобы сделать поток более четким.

## Используйте фигурные скобки, даже при написании однострочных

Систематически это поможет вам сделать это быстрее, и если вы захотите изменить код в будущем, вы сможете сделать это без забот.

Вместо:

```cpp
for (int i = 1; i <= 5; i++) 
    //CODE 
```

Делать:

```cpp
for (int i = 1; i <= 5; i++) 
 { 
    //CODE 
 } 
```

## Другие рекомендации

*   #### Используйте, когда вы знаете количество итераций, пока и делаете, когда вы этого не делаете.
    
*   #### Используйте const, перейдите по значению / ссылке, когда это подходит. Это поможет сэкономить память.
    
*   \#### Записывать const в caps, datatypes, начиная с T и переменных в нижнем регистре.
    

```cpp
const int MAX= 100;             //Constant 
 typedef int TVector[MAX];       //Data type 
 TVector vector;                 //Vector 

```