---
title: C++ Compilers
localeTitle: Компиляторы C ++
---
# Вступление к компиляторам на C ++

Чтобы начать работу с C ++, вам нужно немного узнать о компиляторах и как работает C ++ на вашем компьютере.

Когда все сказано и сделано, компьютеры понимают только один язык, машинный язык. Язык машины полностью состоит из двоичные биты, или 0s и 1s. Хотя можно было бы программировать в двоичном формате, это было бы невероятно утомительно и требовало много времени. Итак, мы, люди, разработали языки программирования, чтобы упростить разработку программного обеспечения. Язык сборки - прямой от 1 до 1 с машиной язык. Языки, такие как C, C ++ и COBOL, немного выше и их необходимо скомпилировать. Это еще больше. Языки как JavaScript и Python имеют компоненты, которые переводится на языки C ++ или других языков низкого уровня, прежде чем они будут скомпилированы, эффективно делая их «высшими» языками, чем C или C ++. Поскольку компьютерная архитектура состоит из электронных переключателей и кабелей, которые могут работать только с двоичными 1 и 0, вам нужен компилятор для перевода кода с высокого уровня C ++ на машинный язык, который может понять процессор.

Компиляторы - это служебные программы, которые принимают ваш код и преобразуют его в исполняемые файлы машинного кода. Когда вы запускаете компилятор во-первых, препроцессор читает исходный код (файл C ++, который вы только что написали). Препроцессор выполняет поиск любого предпроцессорные директивы (строки кода, начинающиеся с символа #). Директивы препроцессора вызывают препроцессор, чтобы каким-то образом изменить ваш код (обычно добавляя некоторую библиотеку или другой файл C ++). Далее, компилятор работает через препроцитированную строку кода путем перевода строки каждой строке в соответствующую инструкцию машинного языка. Это также выявит любые синтаксические ошибки, которые присутствуют в вашем исходный код и вызовет ошибку в командной строке. Наконец, если ошибок нет, компилятор создает объект файл с бинарным файлом машины, который необходимо запустить на вашем компьютере. Хотя объектный файл, созданный компилятором вероятно, достаточно, чтобы что-то сделать на вашем компьютере, он по-прежнему не является исполняемым исполняемым файлом вашей программы на C ++. Существует окончательный важный шаг для достижения исполняемой программы.

C ++ содержит обширную библиотеку, которая помогает выполнять сложные задачи, такие как ввод-вывод и аппаратное манипулирование. Вы можете включить эти библиотеки с препроцессорными директивами, но препроцессор автоматически не добавляет их в ваш код. Для того чтобы вы имели конечная исполняемая программа, другая утилита, известная как компоновщик, должна объединять ваши объектные файлы с библиотечными функциями необходимо для запуска кода. Подумайте об этом как о наличии всех необходимых блоков построить дом. Компилятор сделал все блоки, но компоновщик - тот, который объединяет их все вместе, чтобы наконец создать дом. Как только это будет сделано, теперь у вас есть исполняемый исполняемый файл!

## Как скомпилировать файл

Допустим, у вас есть файл C ++, `helloWorld.cpp` ...

### Если вы находитесь в Windows -

#### Использование и IDE, такие как CodeBlocks

Это так же просто, как нажать кнопки сборки и запуска, они создадут файл в папке проекта. ![IMG](https://i.imgur.com/FwZuFGy.png)

#### Использование командной строки

1.  Откройте командную строку разработчика - для этого шага вам понадобится Microsoft Visual Studio или другая среда IDE, позволяет вам скомпилировать вашу программу из командной строки. Вы также можете искать онлайн-компиляторы C ++.
    
2.  Перейдите непосредственно к исходному коду
    
3.  Запустите компилятор в исходном коде (при условии, что вы используете компилятор Microsoft Visual Studio) `cl /EHsc helloWorld.cpp`
    

Теперь это создаст объектный файл и автоматически свяжет его для вас. Если вы посмотрите в ту же папку, вы увидите В настоящее время присутствует исполняемый файл hellWorld.exe (обратите внимание на расширение exe).

4.  Введите `helloWorld` в приглашение для запуска исполняемого файла

Кроме того, многие IDE позволяют быстро создавать и просматривать вашу программу. Это может быть проще, так как ваша версия окна могут не быть предварительно упакованы с помощью утилиты компилятора.

### Если вы находитесь в Linux или OSX -

1.  Откройте окно терминала и перейдите в каталог исходного кода
2.  Запустите компилятор в исходном коде `g++ helloWorld.cpp -o helloWorld`

Это создаст объектный файл и автоматически свяжет его для вас. Посмотрите в папку, и вы увидите helloWorld.exe исполняемый файл (обратите внимание на расширение exe).

3.  Введите `./helloWorld` в окне терминала, чтобы запустить исполняемый файл

g ++ является стандартным компилятором Linux и является отличной утилитой. Он поставляется в комплекте с операционной системой.

ЗАМЕТКА: непосредственно компилировать и выполнять свой код, запускать `g++ -o helloWorld helloWorld.cpp; ./helloWorld` поэтому, когда вам нужно многократно компилировать и запускать код, вверх стрелка-введите

* * *

Существует несколько разных типов компиляторов. Два из них - это два, которые обычно упаковываются вместе с Windows или Linux / OSX.