---
title: Functions in C++
localeTitle: Функции в C ++
---
## Определение:

Функция представляет собой группу операторов, которые вместе выполняют задачу. Каждая программа на C ++ имеет хотя бы одну функцию, которая является main ().

Объявление функции сообщает компилятору о имени функции, типе возвращаемого значения и параметрах. Определение функции обеспечивает фактическое тело функции.

## Общая форма определения функции C ++:

```cpp
return_type function_name( parameter list ) 
 { 
   body of the function 
 } 
```

### Тип возврата:

Функция может вернуть значение. Тип возврата _\- это тип данных значения, возвращаемого функцией. Некоторые функции выполняют требуемые операции без возврата значения. В этом случае возвращаемым_ типом является ключевое слово void.

### Имя функции:

Это фактическое имя функции. Имя функции и список параметров вместе составляют подпись функции.

### Параметры:

Параметр подобен заполнителю. Когда функция вызывается, вы передаете значение параметру. Это значение называется фактическим параметром или аргументом. Список параметров относится к типу, порядку и количеству параметров функции. Параметры являются необязательными; то есть функция не может содержать никаких параметров.

### Тело функции:

Тело функции содержит набор операторов, которые определяют, что делает функция.

## Пример:

```cpp
int max(int num1, int num2) 
 { 
   // local variable declaration 
   int result; 
 
   if (num1 > num2) 
      result = num1; 
   else 
      result = num2; 
 
   return result; 
 } 
```

## Почему важны функции?

Функции поддерживают модульность (разбиение работы на более мелкие фрагменты, называемые модулями), что является существенной особенностью ООП, которая в основном отделяет C ++ от C. Наличие определенных функций для выполнения конкретных задач устраняет путаницу и сокращает длину основной функции. Функция также выполняет повторное использование кода. Таким образом, в следующий раз, когда вам нужно будет вычислить максимум двух разных чисел в азарте и снова в одной программе, вам не нужно копировать и вставлять код. Вам просто нужно вызвать функцию, и она оставит работу.

## Больше информации

*   [TutorialsPoint](https://www.tutorialspoint.com/cplusplus/cpp_functions.htm)