---
title: C++
localeTitle: C ++
---
# Привет, мир! - Ваша первая программа на C ++

## Что такое C ++?

*   C ++ - это язык программирования общего назначения, который использовался с 1990-х годов
    
*   Он был разработан Бьярне Страуступом под названием «C с классами».
    
*   Это версия C, которая включает объектно-ориентированные элементы, включая классы и функции.
    
*   Он считается одним из самых больших языков программирования, как вы можете видеть на следующем изображении: ![Img](http://static1.businessinsider.com/image/59deb30392406c21008b6148-1200/for-bonus-points-heres-the-chart-showing-these-languages-relative-popularity.jpg) _источник: Github_
    

### Ваша первая программа на C ++

```cpp
#include <iostream> 
 using namespace std; 
 int main() 
 { 
    cout << "Hello World" << endl; 
    return 0; 
 } 
```

#### Результат этой программы будет просто:
```
Hello World! 
```

Теперь давайте разложим код:

#### Строки 1 и 2

```cpp
#include <iostream> 
 using namespace std; 
```

*   Первая строка сообщает компьютеру использовать заголовочный файл «iostream» для этой конкретной программы. Заголовочный файл представляет собой отдельный файл с предварительно написанным кодом на C ++. Существует много других файлов заголовков, которые требуются для правильной работы определенной программы. Некоторые из них: математика, вектор и строка. Заголовочные файлы обычно представлены расширением «.h» (вам не нужно добавлять .h при включении стандартных файлов библиотеки C ++)
*   `iostream` обозначает поток ввода-вывода. Файл «iostream» содержит код, позволяющий компьютеру принимать входные данные и генерировать выходные данные с использованием языка C ++.
*   Вторая строка указывает компьютеру использовать стандартное пространство имен, которое включает в себя функции стандартного C ++. Вы можете написать эту программу без этой строки, но вам придется использовать `std::cout` вместо `cout` и `std::endl` вместо `endl` в строке 4. Это делает код более читабельным и наша жизнь проще программистов.

#### Строки 3 и 4

```cpp
int main() 
 { 
```

*   C ++ запускает выполнение программы из -main function- `int main()` . Во время выполнения компьютер запускает код из каждой строки из `{` (открывающая скобка) до `}` (закрывающая скобка) **ПРИМЕЧАНИЕ. Каждая функция начинается с открывающей фигурной скобки «{» и заканчивается закрывающей фигурной скобкой «}».**
*   Строка 4 указывает начало функции main ().

#### Строки 5, 6 и 7

```cpp
    cout << "Hello World" << endl; 
    return 0; 
 } 
```

*   Для вывода используется слово `cout` в C ++.
*   За ним следует `<<` , _оператор вставки_ .
*   Что бы ни было в двойных кавычках `""` печатается. Некоторые специальные символы имеют другой синтаксис для операторов печати
*   Теперь, чтобы печатать любые другие данные, вы должны добавить `<<` .

**_Задача: попробуйте изменить Hello World на любое другое предложение или слово (и). Какой будет выход?_**

*   `endl` - зарезервированное слово при использовании языка C ++ для **завершения этой строки и перехода к следующей строке во время вывода** . - _cout означает «консольный вывод»_
*   Наконец, завершите команду точкой с запятой `;` ,

**ПРИМЕЧАНИЕ. Каждая команда, кроме определения основной функции и директивы #include, должна заканчиваться точкой с запятой. Без ";" , вы можете столкнуться с ошибкой.**

*   `return 0;` безопасно завершает текущую функцию, то есть «main ()» в этом случае, и поскольку после «main ()» функция не прекращается, программа прекращается.
*   Не забудьте сообщить компьютеру, что это конец функции main (). Для этого вы добавляете закрывающуюся фигурную скобку «}». Вы столкнетесь с ошибкой перед выполнением программы, если вы не включите **}** .

### Код должен выглядеть примерно так:

![Img](https://i.imgur.com/d1liGwI.png)

Программисты используют программу Hello World (например, эту) в качестве ритуала использования нового языка программирования. Это символ удачи.  
_Вы закончили кодирование своей первой программы на C ++ и поняли большую часть кода, который вы написали / набрали. ПОЗДРАВЛЯЕМ!_

**Удачи всем вам и счастливым кодированием! :)**

**Счастливое кодирование! :)**

**Не стесняйтесь задавать любые вопросы на странице GitHub [FreeCodeCamp](https://forum.freecodecamp.org/) или [форуме FreeCodeCamp.](https://forum.freecodecamp.org/)**

[Попробуй сам ! :)](https://repl.it/L4k3)

**Возможно, вам понадобится программное обеспечение для написания и выполнения кода на C ++. Я рекомендую использовать CodeBlocks. Ниже приведена ссылка для загрузки:**

Ссылка для [скачивания](http://www.codeblocks.org/downloads/26) : [Загрузить здесь](http://www.codeblocks.org/downloads/26)

*   Нажмите ссылку с компилятором GNU / GCC для окон. Это не потребует дополнительной установки

Другие альтернативы могут быть визуальной студией, используя компилятор или интерактивную среду IDE, такую ​​как Cloud9 или repl.it

Ссылка # 2 для Mac: [Скачать для Mac # 2 здесь](https://developer.apple.com/xcode/)