---
title: Inline Function
localeTitle: Встроенная функция
---
# Встроенная функция

## Введение

Встроенная функция - это специальная функция, определенная в C ++, и при ее вызове расширяется встроенная.

Теперь, что это значит?

Всякий раз, когда вызывается функция, требуется много дополнительного времени для выполнения ряда действий, таких как переход к функции, сохранение регистров, перенос аргументов в стек и возврат к вызывающей функции. Так что это занимает много времени. Но встроенная функция - это функция, в которой компилятор был запрошен для выполнения встроенного расширения. Если функция запрашивает компилятор для вставки полного тела функции в каждое место, вызываемое функцией, вместо генерации кода для вызова функции в одном месте, она определена.

Однако мы не можем гарантировать, что каждая функция, объявленная inline, будет встроенной. Потому что, когда мы объявляем функцию `inline` , это запрос, а не команда. Компилятор может игнорировать запрос вложения в следующих ситуациях: - 1) Если функция содержит цикл, например, `for` цикла, `while` loop, `do-while` loop и т. Д. 2) Если функция содержит оператор `switch` или `goto` . 3) Если функция ничего не возвращает, даже если указан тип возврата (кроме, конечно, `void` ). 4) Если функция содержит статическую переменную. 5) Если функция содержит рекурсивный вызов.

\`\` \`c ++

## синтаксис: -

inline return _type_ имя _функции_ (argument\_list) {

// функция тела

}
```
## When to use Inline function 
 
 * When the function performs small tasks and is called very often. 
 * When performance is important. 
 * Instead of a macro. 
```

C ++

# включают

использование пространства имен std;

класс MathOperation {

общественности:
```
inline int add(int x, int y){ 
 
  return(x+y); 
 } 
 
 inline float div(int n1, float n2){ 
 
  return(n1/n2); 
 } 
```

};

int main () {

MathOperation obj;

cout << "Дополнение:" << obj.add (34,12) << <"\\ n"; cout << "Раздел:" << obj.div (12,3.4) << "\\ n";

return 0;

} \`\` \`

## Преимущества функции Inline

*   Это экономит накладные расходы на возврат вызова из функции.
*   Он увеличивает локальность ссылок, используя кеш команд.
*   Это ускоряет работу вашей программы, избегая накладных расходов на функции.
*   Это экономит накладные расходы на операции push / pop в стеке, когда происходят вызовы функций.
*   В заголовочном файле можно поместить определение функции, то есть оно может быть включено в несколько единиц компиляции без жалобы компоновщика.

## Недостатки встроенной функции

*   При использовании в заголовке он делает ваш заголовочный файл более крупным с информацией, которую пользователи не заботятся.
*   Это увеличивает размер исполняемого файла из-за расширения кода.
*   C ++ inlining разрешается во время компиляции. Это означает, что если вы измените код встроенной функции, вам нужно будет перекомпилировать весь код, используя его, чтобы убедиться, что он будет обновлен.
*   Как упоминалось выше, он увеличивает размер исполняемого файла, что может привести к переполнению памяти. Больше ошибок страницы, что снижает производительность вашей программы.