---
title: Inline Functions in C++
localeTitle: Встроенные функции в C ++
---
## Встроенные функции в C ++

Когда программа выполняет инструкцию вызова функции, CPU сохраняет адрес памяти инструкции после вызова функции, копирует аргументы функции в стеке и, наконец, передает управление указанной функции. Затем CPU выполняет код функции, сохраняет возвращаемое значение функции в предопределенной ячейке памяти / регистре и возвращает управление вызывающей функции. Это может стать накладным, если время выполнения функции меньше времени переключения от вызывающей функции до вызываемой функции (вызываемого абонента). Для функций, которые являются большими и / или выполняют сложные задачи, накладные расходы на вызов функции обычно незначительны по сравнению с количеством времени, которое должна выполнять функция. Однако для небольших, часто используемых функций время, необходимое для выполнения вызова функции, часто намного больше, чем время, необходимое для фактического выполнения кода функции. Эти накладные расходы возникают для небольших функций, поскольку время выполнения небольшой функции меньше времени переключения.

C ++ предоставляет встроенные функции для сокращения служебных вызовов функции. Встроенная функция - это функция, которая расширяется в строке при ее вызове. Когда встроенная функция называется целым кодом встроенной функции, она вставлена ​​или заменяется в точке встроенного вызова функции. Эта подстановка выполняется компилятором C ++ во время компиляции. Встроенная функция может повысить эффективность, если она мала. Синтаксис для определения функции inline:

```cpp
inline return-type function-name(parameters) 
 { 
    // function code 
 } 
```

Помните, что inlining - это всего лишь запрос компилятору, а не команда. Компилятор может игнорировать запрос на inlining. Компилятор не может выполнять инкрустацию в таких ситуациях, как:

*   Если функция содержит цикл. (пока, пока-то)
*   Если функция содержит статические переменные.
*   Если функция рекурсивна.
*   Если возвращаемый тип функции отличен от void, а оператор return не существует в теле функции.
*   Если функция содержит оператор switch или goto.

### Встроенные функции обеспечивают следующие преимущества:

*   Невыполнение служебных вызовов функции не происходит.
*   Он также экономит накладные расходы переменных push / pop в стеке при вызове функции.
*   Это также экономит накладные расходы при обратном вызове функции.
*   Когда вы встраиваете функцию, вы можете разрешить компилятору выполнять оптимизацию по контексту в теле функции. Такая оптимизация невозможна для обычных вызовов функций. Другие оптимизации можно получить, рассмотрев потоки вызывающего контекста и вызываемого контекста.
*   Встроенная функция может быть полезна (если она мала) для встроенных систем, потому что inline может давать меньше кода, чем преамбула вызова функции и возврат.

### Недостатки встроенной функции:

*   Добавленные переменные из встроенной функции потребляют дополнительные регистры, после функции подкладки, если число переменных, которое будет использовать регистр, увеличивается, чем они могут создавать накладные расходы на использование переменных переменных реестра. Это означает, что когда тело встроенной функции заменяется в точке вызова функции, общее число переменных, используемых функцией, также вставлено. Таким образом, число регистров, которые будут использоваться для переменных, также будет увеличено. Таким образом, если после того, как функция, вставляющая число переменных, резко возрастает, это, несомненно, вызовет накладные расходы на использование регистра.
    
*   Если вы используете слишком много встроенных функций, размер двоичного исполняемого файла будет большим, из-за дублирования одного и того же кода.
    
*   Слишком большая инкрустация также может снизить скорость атаки кеша команд, тем самым уменьшая скорость выборки команд из памяти кеша до памяти первичной памяти.
    
*   Встроенная функция может увеличить время выполнения компиляции, если кто-то изменит код внутри встроенной функции, тогда все вызывающие места должны быть перекомпилированы, потому что компилятору потребуется заменить весь код еще раз, чтобы отразить изменения, в противном случае он будет продолжаться со старыми функциями.
    
*   Встроенные функции не могут быть полезны для многих встроенных систем. Потому что во встроенных системах размер кода более важен, чем скорость.
    
*   Встроенные функции могут вызывать избиение, поскольку вложение может увеличить размер исполняемого файла. Захват в памяти приводит к ухудшению производительности компьютера.
    

Следующая программа демонстрирует эту концепцию:

```cpp
#include <iostream> 
 using namespace std; 
 class operation 
 { 
    int a,b,add,sub,mul; 
    float div; 
 public: 
    void get(); 
    void sum(); 
    void difference(); 
    void product(); 
    void division(); 
 }; 
 inline void operation :: get() 
 { 
    cout << "Enter first value:"; 
    cin >> a; 
    cout << "Enter second value:"; 
    cin >> b; 
 } 
 
 inline void operation :: sum() 
 { 
    add = a+b; 
    cout << "Addition of two numbers: " << a+b << "\n"; 
 } 
 
 inline void operation :: difference() 
 { 
    sub = ab; 
    cout << "Difference of two numbers: " << ab << "\n"; 
 } 
 
 inline void operation :: product() 
 { 
    mul = a*b; 
    cout << "Product of two numbers: " << a*b << "\n"; 
 } 
 
 inline void operation ::division() 
 { 
    div=a/b; 
    cout<<"Division of two numbers: "<<a/b<<"\n" ; 
 } 
 
 int main() 
 { 
    cout << "Program using inline function\n"; 
    operation s; 
    s.get(); 
    s.sum(); 
    s.difference(); 
    s.product(); 
    s.division(); 
    return 0; 
 } 
```

Вывод:
```
Enter first value: 45 
 Enter second value: 15 
 Addition of two numbers: 60 
 Difference of two numbers: 30 
 Product of two numbers: 675 
 Division of two numbers: 3 

```