---
title: Input and Output
localeTitle: Вход и выход
---
## Вход и выход с потоками

Чтобы распечатать информацию на консоли или прочитать ее, вы используете `cout` и `cin` , которые являются так называемыми `streams` . Эта метафора используется, потому что вы используете потоки, как если бы вы использовали раковину, или крана: вы либо очищаете данные в раковине ( `cout` ), либо извлекаете данные из крана ( `cin` ).

### Выход с cout

Программа Hello World использует `cout` для печати «Hello World!». на консоль:

```C++
#include<iostream> 
 using namespace std; 
 
 int main() 
 { 
  cout << "Hello world!" << endl; 
 } 
```

Первые две строки наверху необходимы для использования `cout` и других потоков. `#include<iostream>` делает объекты потока недоступными и `using namespace std;` позволяет вам вводить `cout` напрямую, а не вводить `std::cout` , то есть указывать, что мы хотим использовать `cout` из пространства имен `std` .

`cout` означает «Консольный выход» и представляет собой так называемый _выходной поток_ , представляющий консоль. Когда вы хотите напечатать что-то на консоли, вы можете поместить его в `cout` ; Представьте, что это отверстие, ведущее к терминалу. Чтобы поместить вещи в это отверстие, по одному, вы используете оператор `<<` , также как _оператор вставки_ 1 . Оператор может быть привязан, т. Е. Вы можете поместить несколько вещей один за другим. Следующее напечатает «Торт - ложь».:

`cout << "The cake " << "is " << "a " << "lie." << endl;`

`endl` означает «End Line» и это еще один элемент, который исходит от `<iostream>` . Когда вы вставляете `endl` в `cout` , он будет печатать символ новой строки («\\ n») на консоли, а также _flush_ `cout` , что означает, что он заставит `cout` распечатать все, что вы вложили в него _прямо сейчас_ . Если вы не `endl` в `cout` , `cout` может сохранить данные, которые вы вложили в него, но подождите больше данных, прежде чем на самом деле распечатать все. Это называется _буферизацией_ и очень хорошо подходит для производительности, но если вы уже дали ему все, что он должен печатать, вы хотите, чтобы `cout` печатал его немедленно. Поэтому очень хорошая практика заканчиваться `endl` в тех местах, где это имеет смысл.

Почти все можно поместить в поток: строки, числа, переменные, выражения и т. Д. Здесь приведены некоторые примеры действительных входов потока:

```C++
// Notice we can use the number 42 and not the string "42". 
 cout << "The meaning of life is " << 42 << endl;` // Output: The meaning of life is 42 
```

```C++
string name = "Tim"; 
 cout << "Except for you, " << name << endl;`// Output: Except for you, Tim 
```

```C++
string name = "Tim"; 
 cout << name; 
 cout << " is a great guy!" << endl;` 
 // Output: Tim is a great guy! 
```

```C++
int a = 3; 
 cout << a*2 + 18/a << endl;`// Output: 12 
```

### Заметка о пробеле

C ++ всегда ставит _вас_ под контроль и делает именно то, что вы ему говорите. Иногда это может удивлять, как в следующем примере:

```C++
string name = "Sarah"; 
 cout << "Good morning" << name << "how are you today? << endl; 
```

Вы можете ожидать, что он напечатает «Доброе утро, Сара, как вы сегодня?», Но на самом деле выход будет «Доброе утро, как вы сегодня?». Причина этой ошибки в том , что вы не писали пробелы в строках , окружающих `name` , и поэтому, так как вы не указали никаких пробелов, `cout` не печатали никаких. Правильной версией будет: `cout << "Good morning " << name << " how are you today? << endl;`

Разрывы строк не происходят сами по себе. Вы могли бы подумать, что это напечатает рецепт на четырех строках:

```C++
cout << "To make bread, you need:"; 
 cout << "* One egg"; 
 cout << "* One water"; 
 cout << "* Two wheat"; 
```

но выход на самом деле все на одной линии: «Чтобы сделать хлеб, вам нужно: \* одно яйцо \* одна вода \* две пшеницы». Это связано с тем, что в конце строк нет символов новой строки, поэтому, естественно, C ++ предполагает, что мы не хотим, чтобы он печатал символы новой строки.

Вы можете исправить это, добавив `endl` s после каждой строки, потому что, как обсуждалось ранее, `endl` вставляет символ новой строки в выходной поток. Тем не менее, это также заставляет буфер очищаться, что лишает нас небольшой производительности, так как мы могли напечатать все строки за один раз. Поэтому лучше всего было бы добавить фактических символов новой строки в конце строк и использовать `endl` в конце:

```C++
cout << "To make bread, you need:\n"; 
 cout << "* One egg\n"; 
 cout << "* One water\n"; 
 cout << "* Two wheat" << endl; 
```

Если вы просто печатаете небольшой рецепт, время, которое вы сохраняете, является миниатюрным и не стоит хлопот, но если вы печатаете миллионы предметов, разница может быть очень заметной.

### Вход с cin

Чтобы читать с консоли, вы используете _входной поток_ `cin` же, как и `cout` , но вместо того, чтобы помещать вещи в `cin` , вы «вынимаете их». Следующая программа считывает два числа от пользователя и добавляет их вместе:

```C++
#include<iostream> 
 using namespace std; 
 
 int main() 
 { 
  int a, b; // Variables to hold the two numbers. 
 
  cout << "Please enter the first number:" << endl; 
  cin >> a; 
  cout << "Please enter the second number:" << endl; 
  cin >> b; 
 
  cout << "The sum of your numbers is: " << a + b << endl; 
 } 
```

`cin` означает «Console Input» и представляет собой _входной поток_ , представляющий ввод с консоли. В выражении `cin >> a;` , данные считываются из `cin` и сохраняются в переменной `a` , используя оператор `>>` , _оператор извлечения_ 2 . Оператор извлечения считывает ровно столько же данных, сколько требуется для записи в указанную переменную, и пропускает любые пробелы, поэтому, если пользователь набирает «6», который будет считан только как значение `6` .

Стоит отметить, что `cin` остановит всю программу, чтобы ждать ввода пользователем значения. Программа не будет продолжаться до тех пор, пока пользователь не нажмет кнопку ввода, и в эту переменную будут записаны некоторые данные. Если пользователь просто нажимает клавишу ввода, не набрав ничего, `cin` будет продолжать ждать значения.

Оператор экстракции `<<` может быть скован. Вот та же программа, что и в прошлый раз, но написана более кратким образом:

```C++
#include<iostream> 
 using namespace std; 
 
 int main() 
 { 
  int a, b; // Variables to hold the two numbers. 
 
  cout << "Please enter two numbers:" << endl; 
  cin >> a >> b; 
  cout << "The sum of your numbers is: " << a + b << endl; 
 } 
```

При прикованном цепочке оператор извлечения сначала считывает данные из `cin` для заполнения `a` , а затем считывает данные для заполнения `b` .

Стандартные команды printf и scanf C также могут использоваться с c ++ путем импорта ' 'заголовочный файл.

## источники

1.  http://www.cplusplus.com/reference/ostream/ostream/operator%3C%3C/
2.  http://www.cplusplus.com/reference/istream/istream/operator%3E%3E/